/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.console;

import com.hazelcast.client.console.HazelcastCommandLine;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jline.reader.EOFError;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

public final class SqlConsole {
    private static final int PRIMARY_COLOR = 3;
    private static final int SECONDARY_COLOR = 12;
    private static final int EXPLAIN_ROWS_INITIAL_CAPACITY = 100;
    private static final List<SqlRow> ROWS_BUFFER = new ArrayList<SqlRow>(100);
    private final HazelcastCommandLine.GlobalMixin globalMixin;
    private final HazelcastInstance hzClient;

    public SqlConsole(HazelcastCommandLine.GlobalMixin globalMixin, HazelcastInstance hzClient) {
        this.globalMixin = globalMixin;
        this.hzClient = hzClient;
    }

    public void run() {
        LineReader reader = LineReaderBuilder.builder().parser((Parser)new MultilineParser()).variable("secondary-prompt-pattern", (Object)new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(12)).append((CharSequence)"%M%P > ").toAnsi()).variable("indentation", (Object)2).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).terminal(SqlConsole.systemOrDumbTerminal()).appName("hazelcast-sql").build();
        AtomicReference<SqlResult> activeSqlResult = new AtomicReference<SqlResult>();
        reader.getTerminal().handle(Terminal.Signal.INT, signal -> {
            SqlResult r = (SqlResult)activeSqlResult.get();
            if (r != null) {
                r.close();
            }
        });
        PrintWriter writer = reader.getTerminal().writer();
        writer.println(this.sqlStartingPrompt());
        writer.flush();
        block3: while (true) {
            String command;
            try {
                command = reader.readLine(new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(12)).append((CharSequence)"sql> ").toAnsi()).trim();
            }
            catch (IOError | EndOfFileException e) {
                writer.println(Constants.EXIT_PROMPT);
                writer.flush();
                break;
            }
            catch (UserInterruptException e) {
                continue;
            }
            command = command.trim();
            if (command.length() > 0 && command.charAt(command.length() - 1) == ';') {
                command = command.substring(0, command.length() - 1).trim();
            } else if (command.lastIndexOf(";") >= 0) {
                String errorPrompt = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append((CharSequence)"There are non-whitespace characters after the semicolon").toAnsi();
                writer.println(errorPrompt);
                writer.flush();
                continue;
            }
            if ("".equals(command)) continue;
            if (StringUtil.equalsIgnoreCase("clear", command)) {
                reader.getTerminal().puts(InfoCmp.Capability.clear_screen, new Object[0]);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("help", command)) {
                writer.println(SqlConsole.helpPrompt());
                writer.flush();
                continue;
            }
            if (StringUtil.equalsIgnoreCase("history", command)) {
                History hist = reader.getHistory();
                ListIterator iterator = hist.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block3;
                    History.Entry entry = (History.Entry)iterator.next();
                    if (iterator.hasNext()) {
                        String entryLine = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append((CharSequence)String.valueOf(entry.index() + 1)).append((CharSequence)" - ").append((CharSequence)entry.line()).toAnsi();
                        writer.println(entryLine);
                        writer.flush();
                        continue;
                    }
                    iterator.remove();
                    hist.resetIndex();
                }
            }
            if (StringUtil.equalsIgnoreCase("exit", command)) {
                writer.println(Constants.EXIT_PROMPT);
                writer.flush();
                break;
            }
            this.executeSqlCmd(command, reader.getTerminal(), activeSqlResult);
        }
    }

    private static Terminal systemOrDumbTerminal() {
        try {
            return TerminalBuilder.builder().dumb(true).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void executeSqlCmd(String command, Terminal terminal, AtomicReference<SqlResult> activeSqlResult) {
        PrintWriter out = terminal.writer();
        try (SqlResult sqlResult = this.hzClient.getSql().execute(command, new Object[0]);){
            activeSqlResult.set(sqlResult);
            if (sqlResult.updateCount() != -1L) {
                String message = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append((CharSequence)"OK").toAnsi();
                out.println(message);
                return;
            }
            SqlRowMetadata rowMetadata = sqlResult.getRowMetadata();
            int[] colWidths = SqlConsole.determineColumnWidths(rowMetadata);
            Alignment[] alignments = SqlConsole.determineAlignments(rowMetadata);
            boolean isExplainQuery = command.toLowerCase(Locale.ROOT).startsWith("explain");
            int rowCount = 0;
            if (isExplainQuery) {
                rowCount = SqlConsole.printExplain(rowMetadata, sqlResult, colWidths, alignments, out);
            } else {
                SqlConsole.printMetadataInfo(rowMetadata, colWidths, alignments, out);
                for (SqlRow row : sqlResult) {
                    ++rowCount;
                    SqlConsole.printRow(row, colWidths, alignments, out);
                }
            }
            SqlConsole.printSeparatorLine(sqlResult.getRowMetadata().getColumnCount(), colWidths, out);
            String message = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append((CharSequence)String.valueOf(rowCount)).append((CharSequence)" row(s) selected").toAnsi();
            out.println(message);
        }
        catch (HazelcastSqlException e) {
            String errorPrompt = this.getErrorPrompt(e);
            out.println(errorPrompt);
        }
        catch (Exception e) {
            String unexpectedErrorPrompt = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append((CharSequence)"Encountered an unexpected exception while executing the query:\n").append((CharSequence)e.getMessage()).toAnsi();
            out.println(unexpectedErrorPrompt);
            e.printStackTrace(out);
        }
    }

    private String getErrorPrompt(HazelcastSqlException hazelcastSqlException) {
        Throwable cause = hazelcastSqlException.getCause();
        String errorPrompt = this.globalMixin.isVerbose() && cause != null ? new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append((CharSequence)hazelcastSqlException.getMessage()).append((CharSequence)"\nStack trace:\n").append((CharSequence)cause.getMessage()).toAnsi() : new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append((CharSequence)hazelcastSqlException.getMessage()).toAnsi();
        return errorPrompt;
    }

    private static int printExplain(SqlRowMetadata rowMetadata, SqlResult sqlResult, int[] colWidths, Alignment[] alignments, PrintWriter out) {
        assert (rowMetadata.getColumnCount() == 1) : "Explain query must produce only one column";
        assert (colWidths.length == 1) : "Explain query must produce only one column";
        ROWS_BUFFER.clear();
        sqlResult.iterator().forEachRemaining(ROWS_BUFFER::add);
        int maxLength = 0;
        for (SqlRow row : ROWS_BUFFER) {
            String columnValue = (String)row.getObject(0);
            maxLength = Math.max(maxLength, columnValue.length());
        }
        colWidths[0] = Math.max(maxLength, colWidths[0]);
        SqlConsole.printMetadataInfo(rowMetadata, colWidths, alignments, out);
        for (SqlRow row : ROWS_BUFFER) {
            SqlConsole.printRow(row, colWidths, alignments, out);
        }
        return ROWS_BUFFER.size();
    }

    private String sqlStartingPrompt() {
        HazelcastClientInstanceImpl hazelcastClientImpl = HazelcastCommandLine.getHazelcastClientInstanceImpl(this.hzClient);
        ClientClusterService clientClusterService = hazelcastClientImpl.getClientClusterService();
        String versionString = "Hazelcast " + clientClusterService.getMasterMember().getVersion().toString();
        Cluster cluster = hazelcastClientImpl.getCluster();
        Set<Member> members = cluster.getMembers();
        return new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append((CharSequence)"Connected to ").append((CharSequence)versionString).append((CharSequence)" at ").append((CharSequence)members.iterator().next().getAddress().toString()).append((CharSequence)" (+").append((CharSequence)String.valueOf(members.size() - 1)).append((CharSequence)" more)\n").append((CharSequence)"Type 'help' for instructions").toAnsi();
    }

    private static String helpPrompt() {
        AttributedStringBuilder builder = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append((CharSequence)"Available Commands:\n").append((CharSequence)"  clear    Clears the terminal screen\n").append((CharSequence)"  exit     Exits from the SQL console\n").append((CharSequence)"  help     Provides information about available commands\n").append((CharSequence)"  history  Shows the command history of the current session\n").append((CharSequence)"Hints:\n").append((CharSequence)"  Semicolon completes a query\n").append((CharSequence)"  Ctrl+C cancels a streaming query\n").append((CharSequence)"  https://docs.hazelcast.com/hazelcast/latest/sql/sql-statements.html");
        return builder.toAnsi();
    }

    private static int[] determineColumnWidths(SqlRowMetadata metadata) {
        int colCount = metadata.getColumnCount();
        int[] colWidths = new int[colCount];
        block17: for (int i = 0; i < colCount; ++i) {
            SqlColumnMetadata colMetadata = metadata.getColumn(i);
            SqlColumnType type = colMetadata.getType();
            String colName = colMetadata.getName();
            switch (type) {
                case BOOLEAN: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.BOOLEAN_FORMAT_LENGTH);
                    continue block17;
                }
                case DATE: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.DATE_FORMAT_LENGTH);
                    continue block17;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.TIMESTAMP_WITH_TIME_ZONE_FORMAT_LENGTH);
                    continue block17;
                }
                case DECIMAL: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.DECIMAL_FORMAT_LENGTH);
                    continue block17;
                }
                case REAL: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.REAL_FORMAT_LENGTH);
                    continue block17;
                }
                case DOUBLE: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.DOUBLE_FORMAT_LENGTH);
                    continue block17;
                }
                case INTEGER: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.INTEGER_FORMAT_LENGTH);
                    continue block17;
                }
                case NULL: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.NULL_FORMAT_LENGTH);
                    continue block17;
                }
                case TINYINT: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.TINYINT_FORMAT_LENGTH);
                    continue block17;
                }
                case SMALLINT: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.SMALLINT_FORMAT_LENGTH);
                    continue block17;
                }
                case TIMESTAMP: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.TIMESTAMP_FORMAT_LENGTH);
                    continue block17;
                }
                case BIGINT: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.BIGINT_FORMAT_LENGTH);
                    continue block17;
                }
                case VARCHAR: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.VARCHAR_FORMAT_LENGTH);
                    continue block17;
                }
                case OBJECT: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.OBJECT_FORMAT_LENGTH);
                    continue block17;
                }
                case JSON: {
                    colWidths[i] = SqlConsole.determineColumnWidth(colName, Constants.JSON_FORMAT_LENGTH);
                    continue block17;
                }
                default: {
                    throw new UnsupportedOperationException(type.toString());
                }
            }
        }
        return colWidths;
    }

    private static int determineColumnWidth(String header, int typeLength) {
        return Math.max(Math.min(header.length(), Constants.VARCHAR_FORMAT_LENGTH), typeLength);
    }

    private static Alignment[] determineAlignments(SqlRowMetadata metadata) {
        int colCount = metadata.getColumnCount();
        Alignment[] alignments = new Alignment[colCount];
        block3: for (int i = 0; i < colCount; ++i) {
            SqlColumnMetadata colMetadata = metadata.getColumn(i);
            SqlColumnType type = colMetadata.getType();
            switch (type) {
                case DECIMAL: 
                case REAL: 
                case DOUBLE: 
                case INTEGER: 
                case TINYINT: 
                case SMALLINT: 
                case BIGINT: {
                    alignments[i] = Alignment.RIGHT;
                    continue block3;
                }
                default: {
                    alignments[i] = Alignment.LEFT;
                }
            }
        }
        return alignments;
    }

    private static void printMetadataInfo(SqlRowMetadata metadata, int[] colWidths, Alignment[] alignments, PrintWriter out) {
        int colCount = metadata.getColumnCount();
        SqlConsole.printSeparatorLine(colCount, colWidths, out);
        AttributedStringBuilder builder = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(12));
        builder.append((CharSequence)"|");
        for (int i = 0; i < colCount; ++i) {
            String colName = metadata.getColumn(i).getName();
            colName = SqlConsole.sanitize(colName, colWidths[i]);
            builder.style(AttributedStyle.BOLD.foreground(3));
            SqlConsole.appendAligned(colWidths[i], colName, alignments[i], builder);
            builder.style(AttributedStyle.BOLD.foreground(12));
            builder.append('|');
        }
        out.println(builder.toAnsi());
        SqlConsole.printSeparatorLine(colCount, colWidths, out);
        out.flush();
    }

    private static void printRow(SqlRow row, int[] colWidths, Alignment[] alignments, PrintWriter out) {
        AttributedStringBuilder builder = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(12));
        builder.append((CharSequence)"|");
        int columnCount = row.getMetadata().getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String colString = row.getObject(i) != null ? SqlConsole.sanitize(row.getObject(i).toString(), colWidths[i]) : "NULL";
            builder.style(AttributedStyle.BOLD.foreground(3));
            SqlConsole.appendAligned(colWidths[i], colString, alignments[i], builder);
            builder.style(AttributedStyle.BOLD.foreground(12));
            builder.append('|');
        }
        out.println(builder.toAnsi());
        out.flush();
    }

    private static String sanitize(String s, int width) {
        if (((String)(s = ((String)s).replace("\n", "\\n"))).length() > width) {
            s = ((String)s).substring(0, width - 1) + "\u2026";
        }
        return s;
    }

    private static void appendAligned(int width, String s, Alignment alignment, AttributedStringBuilder builder) {
        int padding = width - s.length();
        assert (padding >= 0);
        if (alignment == Alignment.RIGHT) {
            SqlConsole.appendPadding(builder, padding, ' ');
        }
        builder.append((CharSequence)s);
        if (alignment == Alignment.LEFT) {
            SqlConsole.appendPadding(builder, padding, ' ');
        }
    }

    private static void appendPadding(AttributedStringBuilder builder, int length, char paddingChar) {
        for (int i = 0; i < length; ++i) {
            builder.append(paddingChar);
        }
    }

    private static void printSeparatorLine(int colSize, int[] colWidths, PrintWriter out) {
        AttributedStringBuilder builder = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(12));
        builder.append('+');
        for (int i = 0; i < colSize; ++i) {
            SqlConsole.appendPadding(builder, colWidths[i], '-');
            builder.append('+');
        }
        out.println(builder.toAnsi());
    }

    private static final class MultilineParser
    extends DefaultParser {
        private MultilineParser() {
        }

        public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
            super.setQuoteChars(new char[]{'\'', '\"'});
            super.setEofOnUnclosedQuote(true);
            this.stateCheck(line, cursor);
            return new DefaultParser.ArgumentList((DefaultParser)this, line, Collections.emptyList(), -1, -1, cursor, "'", -1, -1);
        }

        private void stateCheck(String line, int cursor) {
            boolean containsNonWhitespaceData = false;
            int quoteStart = -1;
            int oneLineCommentStart = -1;
            int multiLineCommentStart = -1;
            int lastSemicolonIdx = -1;
            for (int i = 0; i < line.length(); ++i) {
                if (oneLineCommentStart == -1 && multiLineCommentStart == -1 && quoteStart < 0 && this.isQuoteChar(line, i)) {
                    quoteStart = i;
                    containsNonWhitespaceData = true;
                    continue;
                }
                char currentChar = line.charAt(i);
                if (quoteStart >= 0) {
                    if (line.charAt(quoteStart) != currentChar || this.isEscaped(line, i)) continue;
                    quoteStart = -1;
                    continue;
                }
                if (oneLineCommentStart == -1 && line.regionMatches(i, "/*", 0, "/*".length())) {
                    multiLineCommentStart = i;
                    containsNonWhitespaceData = true;
                    continue;
                }
                if (multiLineCommentStart >= 0) {
                    if (i - multiLineCommentStart <= 2 || !line.regionMatches(i - 1, "*/", 0, "*/".length())) continue;
                    multiLineCommentStart = -1;
                    continue;
                }
                if (oneLineCommentStart == -1 && line.regionMatches(i, "--", 0, "--".length())) {
                    oneLineCommentStart = i;
                    containsNonWhitespaceData = true;
                    continue;
                }
                if (oneLineCommentStart >= 0) {
                    if (currentChar != '\n') continue;
                    oneLineCommentStart = -1;
                    continue;
                }
                if (currentChar == ';') {
                    lastSemicolonIdx = i;
                    continue;
                }
                if (Character.isWhitespace(currentChar)) continue;
                containsNonWhitespaceData = true;
            }
            if (Constants.COMMAND_SET.contains(StringUtil.lowerCaseInternal(StringUtil.trim(line)))) {
                return;
            }
            if (this.isEofOnEscapedNewLine() && this.isEscapeChar(line, line.length() - 1)) {
                throw new EOFError(-1, cursor, "Escaped new line");
            }
            if (this.isEofOnUnclosedQuote() && quoteStart >= 0) {
                throw new EOFError(-1, quoteStart, "Missing closing quote", line.charAt(quoteStart) == '\'' ? "quote" : "dquote");
            }
            if (oneLineCommentStart != -1) {
                throw new EOFError(-1, cursor, "One line comment");
            }
            if (multiLineCommentStart != -1) {
                throw new EOFError(-1, cursor, "Missing end of comment", "**");
            }
            if (containsNonWhitespaceData && (lastSemicolonIdx == -1 || lastSemicolonIdx >= cursor)) {
                throw new EOFError(-1, cursor, "Missing semicolon (;)");
            }
        }
    }

    private static class Constants {
        static final Set<String> COMMAND_SET = new HashSet<String>(Arrays.asList("clear", "exit", "help", "history"));
        static final String EXIT_PROMPT = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append((CharSequence)"Exiting from SQL console").toAnsi();
        static final Integer BOOLEAN_FORMAT_LENGTH = 5;
        static final Integer BIGINT_FORMAT_LENGTH = 20;
        static final Integer DATE_FORMAT_LENGTH = 10;
        static final Integer DECIMAL_FORMAT_LENGTH = 25;
        static final Integer DOUBLE_FORMAT_LENGTH = 25;
        static final Integer INTEGER_FORMAT_LENGTH = 12;
        static final Integer NULL_FORMAT_LENGTH = 4;
        static final Integer REAL_FORMAT_LENGTH = 25;
        static final Integer OBJECT_FORMAT_LENGTH = 20;
        static final Integer TINYINT_FORMAT_LENGTH = 4;
        static final Integer SMALLINT_FORMAT_LENGTH = 6;
        static final Integer TIMESTAMP_FORMAT_LENGTH = 19;
        static final Integer TIMESTAMP_WITH_TIME_ZONE_FORMAT_LENGTH = 25;
        static final Integer VARCHAR_FORMAT_LENGTH = 20;
        static final Integer JSON_FORMAT_LENGTH = 40;

        private Constants() {
        }
    }

    private static enum Alignment {
        LEFT,
        RIGHT;

    }
}

