/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.cluster.Address;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class PartitionArrangement {
    private final Map<Address, int[]> remotePartitionAssignment;
    private final int[] allPartitions;
    private final int[] localPartitions;

    PartitionArrangement(Map<Address, int[]> partitionAssignment, Address thisAddress, boolean prunabilityEnabled) {
        this.remotePartitionAssignment = new HashMap<Address, int[]>(partitionAssignment);
        this.localPartitions = this.remotePartitionAssignment.remove(thisAddress);
        if (prunabilityEnabled) {
            this.allPartitions = partitionAssignment.values().stream().flatMapToInt(Arrays::stream).sorted().toArray();
        } else {
            int partitionCount = 0;
            for (int[] value : partitionAssignment.values()) {
                partitionCount += value.length;
            }
            this.allPartitions = new int[partitionCount];
            for (int i = 0; i < this.allPartitions.length; ++i) {
                this.allPartitions[i] = i;
            }
        }
    }

    Map<Address, int[]> getRemotePartitionAssignment() {
        return this.remotePartitionAssignment;
    }

    int[][] assignPartitionsToProcessors(int localParallelism, boolean isEdgeDistributed) {
        int[] ptions = isEdgeDistributed ? this.localPartitions : this.allPartitions;
        int[][] ptionsPerProcessor = PartitionArrangement.createPtionArrays(ptions.length, localParallelism);
        for (int i = 0; i < localParallelism; ++i) {
            int j = 0;
            int ptionIndex = i;
            while (ptionIndex < ptions.length) {
                ptionsPerProcessor[i][j] = ptions[ptionIndex];
                ptionIndex += localParallelism;
                ++j;
            }
        }
        return ptionsPerProcessor;
    }

    private static int[][] createPtionArrays(int ptionCount, int processorCount) {
        int[][] ptionsPerProcessor = new int[processorCount][];
        int quot = ptionCount / processorCount;
        int rem = ptionCount % processorCount;
        Arrays.setAll(ptionsPerProcessor, i -> new int[quot + (i < rem ? 1 : 0)]);
        return ptionsPerProcessor;
    }

    public Map<Address, int[]> remotePartitionAssignmentToOne(Address target) {
        HashMap<Address, int[]> res = new HashMap<Address, int[]>();
        for (Address address : this.remotePartitionAssignment.keySet()) {
            res.put(address, address.equals(target) ? this.allPartitions : new int[]{});
        }
        return res;
    }
}

