/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.operation.AsyncJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.eventservice.impl.Registration;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class AddJobStatusListenerOperation
extends AsyncJobOperation
implements Versioned {
    private boolean isLightJob;
    private Registration registration;

    public AddJobStatusListenerOperation() {
    }

    public AddJobStatusListenerOperation(long jobId, boolean isLightJob, Registration registration) {
        super(jobId);
        this.isLightJob = isLightJob;
        this.registration = registration;
    }

    public CompletableFuture<UUID> doRun() {
        return this.getJobCoordinationService().addJobStatusListener(this.jobId(), this.isLightJob, this.registration);
    }

    @Override
    public int getClassId() {
        return 33;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.isLightJob);
        this.registration.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.isLightJob = in.readBoolean();
        this.registration = new Registration();
        this.registration.readData(in);
    }
}

