/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.internal.locksupport.LockWaitNotifyKey;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.operation.KeyBasedMapOperation;
import com.hazelcast.map.impl.operation.steps.TxnRollbackOpSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.tx.TxnRollbackBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.Notifier;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.WaitNotifyKey;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;
import java.util.UUID;

public class TxnRollbackOperation
extends KeyBasedMapOperation
implements BackupAwareOperation,
Notifier {
    private UUID ownerUuid;
    private UUID transactionId;

    protected TxnRollbackOperation(int partitionId, String name, Data dataKey, UUID ownerUuid, UUID transactionId) {
        super(name, dataKey);
        this.setPartitionId(partitionId);
        this.ownerUuid = ownerUuid;
        this.transactionId = transactionId;
    }

    public TxnRollbackOperation() {
    }

    @Override
    protected void runInternal() {
        this.wbqCapacityCounter().decrement(this.transactionId);
        if (this.recordStore.isLocked(this.getKey()) && !this.recordStore.unlock(this.getKey(), this.ownerUuid, this.getThreadId(), this.getCallId())) {
            throw new TransactionException("Lock is not owned by the transaction! Owner: " + this.recordStore.getLockOwnerInfo(this.getKey()));
        }
    }

    @Override
    public State createState() {
        return super.createState().setTxnId(this.transactionId).setOwnerUuid(this.ownerUuid);
    }

    @Override
    public Step getStartingStep() {
        return TxnRollbackOpSteps.ROLLBACK;
    }

    @Override
    public void logError(Throwable e) {
        if (e instanceof TransactionException) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("failed to execute:" + this, e);
            }
            return;
        }
        super.logError(e);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public final Operation getBackupOperation() {
        return new TxnRollbackBackupOperation(this.name, this.dataKey, this.ownerUuid, this.getThreadId(), this.transactionId);
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return new LockWaitNotifyKey(this.getServiceNamespace(), this.dataKey);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.ownerUuid);
        UUIDSerializationUtil.writeUUID(out, this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.ownerUuid = UUIDSerializationUtil.readUUID(in);
        this.transactionId = UUIDSerializationUtil.readUUID(in);
    }

    @Override
    public int getClassId() {
        return 67;
    }
}

