/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.impl.CapacityPermit;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainer;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskDescriptor;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskHandlerImpl;
import com.hazelcast.scheduledexecutor.impl.TaskDefinition;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class ScheduledExecutorMemberOwnedContainer
extends ScheduledExecutorContainer {
    private static final int MEMBER_DURABILITY = 0;
    private final AtomicBoolean memberPartitionLock = new AtomicBoolean();

    ScheduledExecutorMemberOwnedContainer(String name, CapacityPermit permit, NodeEngine nodeEngine, boolean statisticsEnabled, @Nullable String namespace) {
        super(name, -1, nodeEngine, permit, 0, new ConcurrentHashMap<String, ScheduledTaskDescriptor>(), statisticsEnabled, namespace);
    }

    @Override
    public ScheduledFuture schedule(TaskDefinition definition) {
        try {
            this.acquireMemberPartitionLockIfNeeded();
            ScheduledFuture scheduledFuture = super.schedule(definition);
            return scheduledFuture;
        }
        finally {
            this.releaseMemberPartitionLockIfNeeded();
        }
    }

    @Override
    public boolean shouldParkGetResult(String taskName) {
        return false;
    }

    @Override
    public ScheduledTaskHandler offprintHandler(String taskName) {
        return ScheduledTaskHandlerImpl.of(this.getNodeEngine().getClusterService().getLocalMember().getUuid(), this.getName(), taskName);
    }

    @Override
    protected InvocationBuilder createInvocationBuilder(Operation op) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        return operationService.createInvocationBuilder("hz:impl:scheduledExecutorService", op, this.getNodeEngine().getThisAddress());
    }

    private void acquireMemberPartitionLockIfNeeded() {
        while (!this.memberPartitionLock.compareAndSet(false, true)) {
            Thread.yield();
        }
    }

    private void releaseMemberPartitionLockIfNeeded() {
        this.memberPartitionLock.set(false);
    }
}

