/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.util;

import com.github.caldav4j.CalDAVResource;
import com.github.caldav4j.exceptions.CalDAV4JException;
import com.github.caldav4j.util.UrlUtils;
import java.text.ParseException;
import java.util.Iterator;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.RandomUidGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICalendarUtils {
    private static final Logger log = LoggerFactory.getLogger(ICalendarUtils.class);
    private static final java.util.TimeZone J_TZ_GMT = TimeZone.getTimeZone((String)"GMT");

    public static DateTime createDateTime(int year, int month, int day, int hour, int minutes, int seconds, int milliseconds, TimeZone tz, boolean utc) {
        DateTime dateTime = new DateTime();
        ICalendarUtils.setFields((Date)dateTime, year, month, day, hour, minutes, seconds, milliseconds, tz, utc);
        return dateTime;
    }

    public static DateTime createDateTime(int year, int month, int day, int hour, int minutes, TimeZone tz, boolean utc) {
        DateTime dateTime = new DateTime();
        ICalendarUtils.setFields((Date)dateTime, year, month, day, hour, minutes, 0, 0, tz, utc);
        return dateTime;
    }

    public static Date createDate(int year, int month, int day) {
        Date date = new Date();
        ICalendarUtils.setFields(date, year, month, day, 0, 0, 0, 0, null, false);
        return date;
    }

    public static Date createDateTime(int year, int month, int day, TimeZone tz, boolean utc) {
        DateTime date = new DateTime();
        ICalendarUtils.setFields((Date)date, year, month, day, 0, 0, 0, 0, tz, utc);
        return date;
    }

    public static VEvent getFirstEvent(Calendar calendar) {
        return (VEvent)calendar.getComponents().getComponent("VEVENT");
    }

    public static CalendarComponent getFirstComponent(CalDAVResource resource, String component) {
        return resource.getCalendar().getComponent(component);
    }

    public static CalendarComponent getFirstComponent(Calendar calendar) throws CalDAV4JException {
        return ICalendarUtils.getFirstComponent(calendar, true);
    }

    public static CalendarComponent getFirstComponent(Calendar calendar, boolean skipTimezone) throws CalDAV4JException {
        CalendarComponent ret = null;
        String compType = null;
        for (Object component : calendar.getComponents()) {
            if (!skipTimezone) {
                ret = (CalendarComponent)component;
                continue;
            }
            if (component instanceof VTimeZone) continue;
            if (ret == null) {
                ret = (CalendarComponent)component;
                compType = ret.getClass().getName();
                continue;
            }
            if (compType.equals(component.getClass().getName())) continue;
            throw new CalDAV4JException("Can't get first component: Calendar contains different kinds of component");
        }
        return ret;
    }

    public static String getUIDValue(Calendar calendar) throws CalDAV4JException {
        return ICalendarUtils.getUIDValue((Component)ICalendarUtils.getFirstComponent(calendar));
    }

    public static void setUIDValue(Calendar calendar, String uid) {
        for (Object c : calendar.getComponents()) {
            if (c == null || c instanceof VTimeZone) continue;
            ICalendarUtils.addOrReplaceProperty((Component)c, (Property)new Uid(uid));
        }
    }

    public static String getSummaryValue(VEvent event) {
        return ICalendarUtils.getPropertyValue((Component)event, "SUMMARY");
    }

    public static String getUIDValue(Component component) {
        return ICalendarUtils.getPropertyValue(component, "UID");
    }

    public static String getPropertyValue(Component component, String propertyName) {
        Property property = (Property)component.getProperties().getProperty(propertyName);
        return property == null ? null : property.getValue();
    }

    private static void setFields(Date date, int year, int month, int day, int hour, int minutes, int seconds, int milliseconds, TimeZone tz, boolean utc) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.setTimeZone(tz == null ? J_TZ_GMT : tz);
        if (date instanceof DateTime) {
            if (utc) {
                ((DateTime)date).setUtc(utc);
            } else if (tz != null) {
                ((DateTime)date).setTimeZone(tz);
            }
            calendar.set(10, hour);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            calendar.set(14, milliseconds);
        }
        date.setTime(calendar.getTimeInMillis());
    }

    public static boolean hasProperty(Component c, String propName) {
        PropertyList l = c.getProperties().getProperties(propName);
        return !l.isEmpty();
    }

    public static VEvent getMasterEvent(Calendar calendar, String uid) {
        ComponentList clist = calendar.getComponents().getComponents("VEVENT");
        for (CalendarComponent o : clist) {
            VEvent curEvent = (VEvent)o;
            String curUid = ICalendarUtils.getUIDValue((Component)curEvent);
            if (!uid.equals(curUid) || ICalendarUtils.hasProperty((Component)curEvent, "RECURRENCE-ID")) continue;
            return curEvent;
        }
        return null;
    }

    public static VTimeZone getTimezone(Calendar calendar) {
        ComponentList clist = calendar.getComponents().getComponents("VTIMEZONE");
        Iterator iterator = clist.iterator();
        if (iterator.hasNext()) {
            CalendarComponent o = (CalendarComponent)iterator.next();
            return (VTimeZone)o;
        }
        return null;
    }

    public static CalendarComponent getMasterComponent(Calendar calendar, String uid) {
        ComponentList clist = calendar.getComponents();
        for (CalendarComponent curEvent : clist) {
            String curUid = ICalendarUtils.getUIDValue((Component)curEvent);
            if (!uid.equals(curUid) || ICalendarUtils.hasProperty((Component)curEvent, "RECURRENCE-ID")) continue;
            return curEvent;
        }
        return null;
    }

    public static CalendarComponent getComponentOccurence(Calendar calendar, String uid, String recurrenceId) {
        ComponentList clist = calendar.getComponents();
        for (CalendarComponent curEvent : clist) {
            String curUid = ICalendarUtils.getUIDValue((Component)curEvent);
            String curRid = ICalendarUtils.getPropertyValue((Component)curEvent, "RECURRENCE-ID");
            if (!uid.equals(curUid) || !UrlUtils.equalsIgnoreCase(recurrenceId, curRid)) continue;
            return curEvent;
        }
        return null;
    }

    public static Calendar removeOccurrence(Calendar calendar, String uid, String recurrenceId) throws ParseException {
        ComponentList clist = calendar.getComponents();
        CalendarComponent master = null;
        CalendarComponent toBeRemoved = null;
        for (CalendarComponent curEvent : clist) {
            if (master == null && !(curEvent instanceof VTimeZone)) {
                master = curEvent;
            }
            String curUid = ICalendarUtils.getUIDValue((Component)curEvent);
            String curRid = ICalendarUtils.getPropertyValue((Component)curEvent, "RECURRENCE-ID");
            if (!uid.equals(curUid) || !UrlUtils.equalsIgnoreCase(recurrenceId, curRid)) continue;
            toBeRemoved = curEvent;
            break;
        }
        if (toBeRemoved != null) {
            clist.remove(toBeRemoved);
        }
        if (master != null) {
            ExDate x = new ExDate();
            x.setValue(recurrenceId);
            master.getProperties().add((Property)x);
        }
        return calendar;
    }

    public static void addOrReplaceProperty(Component component, Property property) {
        Property oldProp = (Property)component.getProperties().getProperty(property.getName());
        if (oldProp != null) {
            component.getProperties().remove(oldProp);
        }
        component.getProperties().add(property);
    }

    public static Uid setUID(Calendar calendar) throws CalDAV4JException {
        CalendarComponent comp = ICalendarUtils.getFirstComponent(calendar);
        Uid uid = (Uid)comp.getProperties().getProperty("UID");
        if (uid == null) {
            RandomUidGenerator generator = new RandomUidGenerator();
            uid = generator.generateUid();
            comp.getProperties().add((Property)uid);
        }
        return uid;
    }
}

