/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.plugins.sfmenu;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.JQueryPanel;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.ui.plugins.sfmenu.ISfMenuItem;
import org.wicketstuff.jquery.ui.plugins.sfmenu.SfMenuBehavior;

public class SfMenu
extends JQueryPanel {
    private static final long serialVersionUID = 1L;
    private final List<ISfMenuItem> items;
    private final boolean isVertical;
    private WebMarkupContainer root;

    public SfMenu(String id, List<ISfMenuItem> items) {
        this(id, items, false);
    }

    public SfMenu(String id, List<ISfMenuItem> items, Boolean isVertical) {
        super(id);
        this.items = (List)Args.notNull(items, (String)"items");
        this.isVertical = isVertical;
        this.initialize();
    }

    public SfMenu(String id, List<ISfMenuItem> items, Options options) {
        this(id, items, options, false);
    }

    public SfMenu(String id, List<ISfMenuItem> items, Options options, Boolean isVertical) {
        super(id, options);
        this.items = (List)Args.notNull(items, (String)"items");
        this.isVertical = isVertical;
        this.initialize();
    }

    private void initialize() {
        this.root = new WebMarkupContainer("root");
        this.root.add(new Component[]{new ListFragment("list", this.items)});
        if (this.isVertical) {
            this.root.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"sf-menu sf-vertical"))});
        }
        this.add(new Component[]{this.root});
    }

    public List<ISfMenuItem> getItemList() {
        return this.items;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((IJQueryWidget)this, (String)IJQueryWidget.JQueryWidget.getSelector((Component)this.root))});
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new SfMenuBehavior(selector, this.options, this.isVertical);
    }

    private class ListFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public ListFragment(String id, List<ISfMenuItem> items) {
            super(id, "list-fragment", (MarkupContainer)SfMenu.this);
            this.add(new Component[]{new ListView<ISfMenuItem>("items", items){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<ISfMenuItem> item) {
                    ISfMenuItem menuItem = (ISfMenuItem)item.getModelObject();
                    if (menuItem.isEnabled()) {
                        item.add(new Component[]{new ItemFragment("item", menuItem)});
                        item.add(new Component[]{new MenuFragment("menu", menuItem.getItems())});
                    } else {
                        item.add(new Component[]{new DisabledItemFragment("item", menuItem)});
                        item.add(new Component[]{new EmptyPanel("menu")});
                    }
                }
            }});
        }
    }

    private class DisabledItemFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public DisabledItemFragment(String id, ISfMenuItem item) {
            super(id, "item-disable-fragment", (MarkupContainer)SfMenu.this);
            Label label = new Label("title", item.getTitle());
            label.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"disabled"))});
            this.add(new Component[]{label});
        }
    }

    private class ItemFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public ItemFragment(String id, final ISfMenuItem item) {
            super(id, "item-link-fragment", (MarkupContainer)SfMenu.this);
            Link<Void> itemLink = new Link<Void>("item-link"){
                private static final long serialVersionUID = 1L;

                protected CharSequence getURL() {
                    if (item.getPageClass() != null) {
                        return this.urlFor(item.getPageClass(), item.getPageParameters());
                    }
                    if (!Strings.isEmpty((String)item.getPageUrl())) {
                        return item.getPageUrl();
                    }
                    return "javascript:;";
                }

                public void onClick() {
                }
            };
            if (item.isOpenInNewWindow()) {
                itemLink.add(new Behavior[]{new AttributeModifier("target", (Serializable)((Object)"_blank"))});
            }
            itemLink.add(new Component[]{new Label("title", item.getTitle())});
            this.add(new Component[]{itemLink});
        }
    }

    private class MenuFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public MenuFragment(String id, List<ISfMenuItem> items) {
            super(id, "menu-fragment", (MarkupContainer)SfMenu.this);
            this.add(new Component[]{new ListFragment("list", items)});
            this.setVisible(!items.isEmpty());
        }
    }
}

