/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.namefind;

import java.io.IOException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.util.Span;
import opennlp.uima.dictionary.DictionaryResource;
import opennlp.uima.namefind.AbstractNameFinder;
import opennlp.uima.util.AnnotatorUtil;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

public class DictionaryNameFinder
extends AbstractNameFinder {
    private TokenNameFinder mNameFinder;

    public DictionaryNameFinder() {
        super("OpenNLP Dictionary Name annotator");
    }

    @Override
    public void initialize() throws ResourceInitializationException {
        Dictionary nameFinderDictionary;
        try {
            DictionaryResource modelResource = (DictionaryResource)this.context.getResourceObject("opennlp.uima.Dictionary");
            nameFinderDictionary = modelResource.getDictionary();
        }
        catch (ResourceAccessException e) {
            try {
                String modelName = AnnotatorUtil.getRequiredStringParameter(this.context, "opennlp.uima.Dictionary");
                nameFinderDictionary = new Dictionary(AnnotatorUtil.getResourceAsStream(this.context, modelName));
            }
            catch (IOException ie) {
                throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "io_error_dictionary_reading", new Object[]{ie.getMessage()});
            }
        }
        this.mNameFinder = new opennlp.tools.namefind.DictionaryNameFinder(nameFinderDictionary);
    }

    @Override
    protected void postProcessAnnotations(Span[] detectedNames, AnnotationFS[] nameAnnotations) {
    }

    @Override
    protected void documentDone(CAS cas) {
    }

    @Override
    protected Span[] find(CAS cas, String[] tokens) {
        return this.mNameFinder.find(tokens);
    }

    public void destroy() {
        this.mNameFinder = null;
    }
}

