/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.interceptor;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Context;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.List;
import org.apache.rocketmq.acl.AccessResource;
import org.apache.rocketmq.acl.AccessValidator;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AuthenticationHeader;
import org.apache.rocketmq.acl.plain.PlainAccessResource;
import org.apache.rocketmq.common.constant.GrpcConstants;
import org.apache.rocketmq.proxy.common.utils.GrpcUtils;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.grpc.interceptor.RequestMapping;

public class AuthenticationInterceptor
implements ServerInterceptor {
    protected final List<AccessValidator> accessValidatorList;

    public AuthenticationInterceptor(List<AccessValidator> accessValidatorList) {
        this.accessValidatorList = accessValidatorList;
    }

    public <R, W> ServerCall.Listener<R> interceptCall(ServerCall<R, W> call, final Metadata headers, ServerCallHandler<R, W> next) {
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<R>(next.startCall(call, headers)){

            public void onMessage(R message) {
                GeneratedMessageV3 messageV3 = (GeneratedMessageV3)message;
                GrpcUtils.putHeaderIfNotExist(headers, GrpcConstants.RPC_NAME, messageV3.getDescriptorForType().getFullName());
                GrpcUtils.putHeaderIfNotExist(headers, GrpcConstants.SIMPLE_RPC_NAME, messageV3.getDescriptorForType().getName());
                if (ConfigurationManager.getProxyConfig().isEnableACL()) {
                    try {
                        AuthenticationHeader authenticationHeader = AuthenticationHeader.builder().remoteAddress((String)((Metadata)GrpcConstants.METADATA.get(Context.current())).get(GrpcConstants.REMOTE_ADDRESS)).namespace((String)((Metadata)GrpcConstants.METADATA.get(Context.current())).get(GrpcConstants.NAMESPACE_ID)).authorization((String)((Metadata)GrpcConstants.METADATA.get(Context.current())).get(GrpcConstants.AUTHORIZATION)).datetime((String)((Metadata)GrpcConstants.METADATA.get(Context.current())).get(GrpcConstants.DATE_TIME)).sessionToken((String)((Metadata)GrpcConstants.METADATA.get(Context.current())).get(GrpcConstants.SESSION_TOKEN)).requestId((String)((Metadata)GrpcConstants.METADATA.get(Context.current())).get(GrpcConstants.REQUEST_ID)).language((String)((Metadata)GrpcConstants.METADATA.get(Context.current())).get(GrpcConstants.LANGUAGE)).clientVersion((String)((Metadata)GrpcConstants.METADATA.get(Context.current())).get(GrpcConstants.CLIENT_VERSION)).protocol((String)((Metadata)GrpcConstants.METADATA.get(Context.current())).get(GrpcConstants.PROTOCOL_VERSION)).requestCode(RequestMapping.map(messageV3.getDescriptorForType().getFullName())).build();
                        AuthenticationInterceptor.this.validate(authenticationHeader, headers, messageV3);
                        super.onMessage(message);
                    }
                    catch (AclException aclException) {
                        throw new StatusRuntimeException(Status.PERMISSION_DENIED, headers);
                    }
                } else {
                    super.onMessage(message);
                }
            }
        };
    }

    protected void validate(AuthenticationHeader authenticationHeader, Metadata headers, GeneratedMessageV3 messageV3) {
        for (AccessValidator accessValidator : this.accessValidatorList) {
            AccessResource accessResource = accessValidator.parse(messageV3, authenticationHeader);
            accessValidator.validate(accessResource);
            if (!(accessResource instanceof PlainAccessResource)) continue;
            PlainAccessResource plainAccessResource = (PlainAccessResource)accessResource;
            GrpcUtils.putHeaderIfNotExist(headers, GrpcConstants.AUTHORIZATION_AK, plainAccessResource.getAccessKey());
        }
    }
}

