/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.lock;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.lock.AdaptiveBackOffSpinLock;
import org.apache.rocketmq.store.lock.BackOffReentrantLock;
import org.apache.rocketmq.store.lock.BackOffSpinLock;

public class AdaptiveBackOffSpinLockImpl
implements AdaptiveBackOffSpinLock {
    private AdaptiveBackOffSpinLock adaptiveLock;
    private AtomicBoolean state = new AtomicBoolean(true);
    private static final float SWAP_SPIN_LOCK_RATIO = 0.8f;
    private static final int SPIN_LOCK_ADAPTIVE_RATIO = 4;
    private static final int BASE_SWAP_LOCK_RATIO = 320;
    private static final String BACK_OFF_SPIN_LOCK = "SpinLock";
    private static final String REENTRANT_LOCK = "ReentrantLock";
    private Map<String, AdaptiveBackOffSpinLock> locks;
    private final List<AtomicInteger> tpsTable;
    private final List<Set<Thread>> threadTable;
    private int swapCriticalPoint;
    private AtomicInteger currentThreadNum = new AtomicInteger(0);
    private AtomicBoolean isOpen = new AtomicBoolean(true);

    public AdaptiveBackOffSpinLockImpl() {
        this.locks = new HashMap<String, AdaptiveBackOffSpinLock>();
        this.locks.put(REENTRANT_LOCK, new BackOffReentrantLock());
        this.locks.put(BACK_OFF_SPIN_LOCK, new BackOffSpinLock());
        this.threadTable = new ArrayList<Set<Thread>>(2);
        this.threadTable.add(ConcurrentHashMap.newKeySet());
        this.threadTable.add(ConcurrentHashMap.newKeySet());
        this.tpsTable = new ArrayList<AtomicInteger>(2);
        this.tpsTable.add(new AtomicInteger(0));
        this.tpsTable.add(new AtomicInteger(0));
        this.adaptiveLock = this.locks.get(BACK_OFF_SPIN_LOCK);
    }

    @Override
    public void lock() {
        boolean state;
        int slot = LocalTime.now().getSecond() % 2;
        this.threadTable.get(slot).add(Thread.currentThread());
        this.tpsTable.get(slot).getAndIncrement();
        while (!(state = this.state.get())) {
        }
        this.currentThreadNum.incrementAndGet();
        this.adaptiveLock.lock();
    }

    @Override
    public void unlock() {
        this.adaptiveLock.unlock();
        this.currentThreadNum.decrementAndGet();
        if (this.isOpen.get()) {
            this.swap();
        }
    }

    @Override
    public void update(MessageStoreConfig messageStoreConfig) {
        this.adaptiveLock.update(messageStoreConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swap() {
        if (!this.state.get()) {
            return;
        }
        boolean needSwap = false;
        int slot = 1 - LocalTime.now().getSecond() % 2;
        int tps = this.tpsTable.get(slot).get() + 1;
        int threadNum = this.threadTable.get(slot).size();
        this.tpsTable.get(slot).set(-1);
        this.threadTable.get(slot).clear();
        if (tps == 0) {
            return;
        }
        if (this.adaptiveLock instanceof BackOffSpinLock) {
            BackOffSpinLock lock = (BackOffSpinLock)this.adaptiveLock;
            if (lock.getNumberOfRetreat(slot) * 320 >= tps) {
                if (lock.isAdapt()) {
                    lock.adapt(true);
                } else {
                    this.swapCriticalPoint = tps * threadNum;
                    needSwap = true;
                }
            } else if (lock.getNumberOfRetreat(slot) * 320 * 4 <= tps) {
                lock.adapt(false);
            }
            lock.setNumberOfRetreat(slot, 0);
        } else if ((float)(tps * threadNum) <= (float)this.swapCriticalPoint * 0.8f) {
            needSwap = true;
        }
        if (needSwap && this.state.compareAndSet(true, false)) {
            int currentThreadNum;
            while ((currentThreadNum = this.currentThreadNum.get()) != 0) {
            }
            try {
                if (this.adaptiveLock instanceof BackOffSpinLock) {
                    this.adaptiveLock = this.locks.get(REENTRANT_LOCK);
                } else {
                    this.adaptiveLock = this.locks.get(BACK_OFF_SPIN_LOCK);
                    ((BackOffSpinLock)this.adaptiveLock).adapt(false);
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.state.compareAndSet(false, true);
            }
        }
    }

    public List<AdaptiveBackOffSpinLock> getLocks() {
        return (List)this.locks.values();
    }

    public void setLocks(Map<String, AdaptiveBackOffSpinLock> locks) {
        this.locks = locks;
    }

    public boolean getState() {
        return this.state.get();
    }

    public void setState(boolean state) {
        this.state.set(state);
    }

    public AdaptiveBackOffSpinLock getAdaptiveLock() {
        return this.adaptiveLock;
    }

    public List<AtomicInteger> getTpsTable() {
        return this.tpsTable;
    }

    public void setSwapCriticalPoint(int swapCriticalPoint) {
        this.swapCriticalPoint = swapCriticalPoint;
    }

    public int getSwapCriticalPoint() {
        return this.swapCriticalPoint;
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    public void setOpen(boolean open) {
        this.isOpen.set(open);
    }
}

