/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions.references;

import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.IReferenceMName;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;

public class BuiltinReference
implements IReferenceMName {
    private final IASLanguageConstants.BuiltinType builtinType;

    public BuiltinReference(IASLanguageConstants.BuiltinType type) {
        this.builtinType = type;
    }

    @Override
    public String getName() {
        return this.builtinType.getName();
    }

    @Override
    public IDefinition resolve(ICompilerProject project, IASScope scope, DependencyType dependencyType, boolean canEscapeWith) {
        ITypeDefinition definition = project.getBuiltinType(this.builtinType);
        ((ASScope)scope).addDependencyOnBuiltinType(project, this.builtinType, dependencyType);
        return definition;
    }

    @Override
    public String getDisplayString() {
        return this.builtinType.getName();
    }

    @Override
    public Name getMName(ICompilerProject project, IASScope scope) {
        ITypeDefinition def = project.getBuiltinType(this.builtinType);
        if (def == null) {
            return null;
        }
        return ((DefinitionBase)((Object)def)).getMName(project);
    }
}

