/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILiteralContainerNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.IObjectLiteralValuePairNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoDuplicateObjectKeysRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.ObjectLiteralExpressionID, (node, tokenQuery, problems) -> this.checkLiteralContainerNode((ILiteralContainerNode)node, tokenQuery, problems));
        return result;
    }

    private void checkLiteralContainerNode(ILiteralContainerNode objectLiteralNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!ILiteralNode.LiteralType.OBJECT.equals((Object)objectLiteralNode.getLiteralType())) {
            return;
        }
        ContainerNode contentsNode = objectLiteralNode.getContentsNode();
        if (contentsNode == null) {
            return;
        }
        HashSet<String> keyNames = new HashSet<String>();
        for (int i = 0; i < contentsNode.getChildCount(); ++i) {
            IASNode child = contentsNode.getChild(i);
            if (!(child instanceof IObjectLiteralValuePairNode)) continue;
            String keyName = null;
            IObjectLiteralValuePairNode valuePairNode = (IObjectLiteralValuePairNode)child;
            IExpressionNode nameNode = valuePairNode.getNameNode();
            if (nameNode instanceof IIdentifierNode) {
                IIdentifierNode identifierNode = (IIdentifierNode)nameNode;
                keyName = identifierNode.getName();
            } else if (nameNode instanceof ILiteralNode) {
                ILiteralNode literalNode = (ILiteralNode)nameNode;
                if (!ILiteralNode.LiteralType.STRING.equals((Object)literalNode.getLiteralType())) continue;
                keyName = literalNode.getValue();
            }
            if (keyName == null) continue;
            if (keyNames.contains(keyName)) {
                problems.add(new NoDuplicateObjectKeysLinterProblem(nameNode, keyName));
                continue;
            }
            keyNames.add(keyName);
        }
    }

    public static class NoDuplicateObjectKeysLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Object literal contains duplicate key '${keyName}'";
        public String keyName;

        public NoDuplicateObjectKeysLinterProblem(IExpressionNode node, String keyName) {
            super((ISourceLocation)node);
            this.keyName = keyName;
        }
    }
}

