/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.identification.DefaultKeywordClass;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.bind.metadata.MD_KeywordClass;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.Keywords;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Keywords_Type", propOrder={"keywords", "type", "thesaurusName", "keywordClass"})
@XmlRootElement(name="MD_Keywords")
public class DefaultKeywords
extends ISOMetadata
implements Keywords {
    private static final long serialVersionUID = -2765705888428016211L;
    private Collection<InternationalString> keywords;
    private KeywordType type;
    private Citation thesaurusName;
    private DefaultKeywordClass keywordClass;

    public DefaultKeywords() {
    }

    public DefaultKeywords(CharSequence ... keywords) {
        if (keywords != null) {
            for (CharSequence keyword : keywords) {
                InternationalString i18n = Types.toInternationalString(keyword);
                if (this.keywords == null) {
                    this.keywords = DefaultKeywords.singleton(i18n, InternationalString.class);
                    continue;
                }
                this.keywords.add(i18n);
            }
        }
    }

    public DefaultKeywords(Keywords object) {
        super(object);
        if (object != null) {
            this.keywords = DefaultKeywords.copyCollection(object.getKeywords(), InternationalString.class);
            this.type = object.getType();
            this.thesaurusName = object.getThesaurusName();
        }
    }

    public static DefaultKeywords castOrCopy(Keywords object) {
        if (object == null || object instanceof DefaultKeywords) {
            return (DefaultKeywords)object;
        }
        return new DefaultKeywords(object);
    }

    @XmlElement(name="keyword", required=true)
    public Collection<InternationalString> getKeywords() {
        this.keywords = this.nonNullCollection(this.keywords, InternationalString.class);
        return this.keywords;
    }

    public void setKeywords(Collection<? extends InternationalString> newValues) {
        this.keywords = this.writeCollection(newValues, this.keywords, InternationalString.class);
    }

    @XmlElement(name="type")
    public KeywordType getType() {
        return this.type;
    }

    public void setType(KeywordType newValue) {
        this.checkWritePermission(this.type);
        this.type = newValue;
    }

    @XmlElement(name="thesaurusName")
    public Citation getThesaurusName() {
        return this.thesaurusName;
    }

    public void setThesaurusName(Citation newValue) {
        this.checkWritePermission(this.thesaurusName);
        this.thesaurusName = newValue;
    }

    @XmlElement(name="keywordClass")
    @XmlJavaTypeAdapter(value=MD_KeywordClass.Since2014.class)
    @UML(identifier="keywordClass", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public DefaultKeywordClass getKeywordClass() {
        return this.keywordClass;
    }

    public void setKeywordClass(DefaultKeywordClass newValue) {
        this.checkWritePermission(this.keywordClass);
        this.keywordClass = newValue;
    }
}

