/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.io.StringWriter;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.sis.gui.internal.DataFormats;
import org.apache.sis.gui.internal.ExceptionReporter;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.gui.metadata.MetadataTree;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.xml.XML;
import org.apache.sis.xml.internal.shared.LegacyNamespaces;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.IdentifiedObject;

public class StandardMetadataTree
extends MetadataTree {
    public StandardMetadataTree() {
        this(null);
    }

    public StandardMetadataTree(MetadataSummary controller) {
        super(controller, true);
        this.setRowFactory(Row::new);
        if (controller != null) {
            controller.metadataProperty.addListener((p, o, n) -> this.setContent((Metadata)n));
        }
    }

    public void setContent(Metadata metadata) {
        TreeTable tree = metadata == null ? null : (metadata instanceof AbstractMetadata ? ((AbstractMetadata)metadata).asTreeTable() : MetadataStandard.ISO_19115.asTreeTable((Object)metadata, Metadata.class, ValueExistencePolicy.COMPACT));
        this.setContent(tree);
    }

    private static final class Row
    extends MetadataTree.Row {
        private final MenuItem copyAsXML;
        private final MenuItem copyAsLegacy;
        private final MenuItem copyAsWKT;
        private final Menu copyAs;

        Row(TreeTableView<TreeTable.Node> view) {
            super(view);
            StandardMetadataTree md = (StandardMetadataTree)view;
            Resources localized = Resources.forLocale(md.getLocale());
            this.copyAsXML = new MenuItem();
            this.copyAsWKT = new MenuItem("WKT \u2014 Well Known Text");
            this.copyAsLegacy = new MenuItem("XML \u2014 Metadata (2007)");
            this.copyAs = new Menu(localized.getString((short)12), null, new MenuItem[]{this.copyAsWKT, this.copyAsXML, this.copyAsLegacy});
            this.menu.getItems().add((Object)this.copyAs);
            this.copyAsLegacy.setOnAction((EventHandler)this);
            this.copyAsXML.setOnAction((EventHandler)this);
            this.copyAsWKT.setOnAction((EventHandler)this);
        }

        @Override
        protected void updateItem(TreeTable.Node item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty && this.copyAs != null) {
                Object obj;
                boolean disabled = true;
                TreeTable.Node node = (TreeTable.Node)this.getItem();
                if (node != null && (obj = node.getUserObject()) != null) {
                    if (MetadataStandard.ISO_19115.isMetadata(obj.getClass())) {
                        this.copyAsXML.setText("XML \u2014 Metadata (2016)");
                        this.copyAsWKT.setDisable(true);
                        this.copyAsLegacy.setDisable(false);
                        disabled = false;
                    } else if (obj instanceof IdentifiedObject) {
                        this.copyAsXML.setText("XML \u2014 Geographic Markup Language");
                        this.copyAsWKT.setDisable(false);
                        this.copyAsLegacy.setDisable(true);
                        disabled = false;
                    }
                }
                this.copyAs.setDisable(disabled);
            }
        }

        @Override
        public void handle(ActionEvent event) {
            TreeTable.Node node = (TreeTable.Node)this.getItem();
            if (node != null) {
                Object obj = node.getUserObject();
                if (obj == null) {
                    super.handle(event);
                } else {
                    Object source = event.getSource();
                    ClipboardContent content = new ClipboardContent();
                    try {
                        String text;
                        if (source == this.copyAsWKT) {
                            WKTFormat f = new WKTFormat();
                            text = f.format(obj);
                        } else if (source == this.copyAsXML) {
                            text = XML.marshal((Object)obj);
                            content.put((Object)DataFormats.XML, (Object)text);
                        } else if (source == this.copyAsLegacy) {
                            StringWriter output = new StringWriter();
                            XML.marshal((Object)obj, (Result)new StreamResult(output), Map.of("org.apache.sis.xml.version.metadata", LegacyNamespaces.VERSION_2007));
                            text = output.toString();
                            content.put((Object)DataFormats.ISO_19139, (Object)text);
                        } else {
                            text = Row.toString(obj);
                        }
                        content.putString(text);
                        Clipboard.getSystemClipboard().setContent((Map)content);
                    }
                    catch (Exception e) {
                        Resources localized = Resources.forLocale(((MetadataTree)this.getTreeTableView()).getLocale());
                        ExceptionReporter.show((Node)this, localized.getString((short)18), localized.getString((short)4), (Throwable)e);
                    }
                }
            }
        }
    }
}

