/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.csv;

import java.io.IOException;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.LogRecord;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.storage.csv.FeatureIterator;
import org.apache.sis.storage.csv.FixedSizeList;
import org.apache.sis.storage.csv.MovingFeatureBuilder;
import org.apache.sis.storage.csv.Store;

final class MovingFeatureIterator
extends FeatureIterator
implements Consumer<LogRecord> {
    private String identifier;
    private MovingFeatureBuilder builder;
    private final Map<String, MovingFeatureBuilder> builders = new LinkedHashMap<String, MovingFeatureBuilder>();

    MovingFeatureIterator(Store store) {
        super(store);
    }

    AbstractFeature[] createMovingFeatures() {
        int n = 0;
        int np = this.values.length - 3;
        AbstractFeature[] features = new AbstractFeature[this.builders.size()];
        for (Map.Entry<String, MovingFeatureBuilder> entry : this.builders.entrySet()) {
            features[n++] = this.createMovingFeature(entry.getKey(), entry.getValue(), np);
        }
        return features;
    }

    private AbstractFeature createMovingFeature(String featureName, MovingFeatureBuilder mf, int np) {
        AbstractFeature feature = this.store.featureType.newInstance();
        feature.setPropertyValue(this.propertyNames[0], (Object)featureName);
        mf.storeTimeRange(this.propertyNames[1], this.propertyNames[2], feature);
        int column = 0;
        if (this.store.hasTrajectories()) {
            mf.storeGeometry(featureName, column, this.store.spatialDimensionCount(), this.store.geometries, (AbstractAttribute)feature.getProperty(this.propertyNames[3]), this);
            ++column;
        }
        while (column < np) {
            mf.storeAttribute(column, (AbstractAttribute)feature.getProperty(this.propertyNames[3 + column]));
            ++column;
        }
        return feature;
    }

    boolean readMoving(Consumer<? super AbstractFeature> action, boolean all) throws IOException {
        String line;
        FixedSizeList elements = new FixedSizeList(this.values);
        int np = this.values.length - 3;
        while ((line = this.store.readLine()) != null) {
            Store.split(line, elements);
            int n = elements.size();
            for (int i = 0; i < n; ++i) {
                this.values[i] = this.converters[i].apply((Object)((String)this.values[i]));
            }
            String mfIdRef = (String)this.values[0];
            long startTime = ((Instant)this.values[1]).toEpochMilli();
            long endTime = ((Instant)this.values[2]).toEpochMilli();
            String publish = null;
            if (!mfIdRef.equals(this.identifier)) {
                publish = this.identifier;
                this.identifier = mfIdRef;
                this.builder = this.builders.computeIfAbsent(mfIdRef, k -> new MovingFeatureBuilder(this.builder, np));
            }
            this.builder.addTimeRange(startTime, endTime);
            for (int i = 0; i < np; ++i) {
                this.builder.addValue(i, startTime, endTime, this.values[i + 3]);
            }
            if (publish != null && action != null) {
                action.accept((AbstractFeature)this.createMovingFeature(publish, this.builders.remove(publish), np));
                if (!all) {
                    return true;
                }
            }
            elements.clear();
        }
        return false;
    }

    @Override
    public void accept(LogRecord warning) {
        this.store.log(warning);
    }
}

