/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.standalone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.discovery.PropertyProvider;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.impl.standalone.Config;
import org.apache.sling.discovery.impl.standalone.InstanceDescriptionImpl;
import org.apache.sling.discovery.impl.standalone.ProviderInfo;
import org.apache.sling.discovery.impl.standalone.TopologyViewImpl;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DiscoveryService.class})
@Designate(ocd=Config.class)
public class NoClusterDiscoveryService
implements DiscoveryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SlingSettingsService settingsService;
    private volatile boolean alwaysOffline = false;
    private TopologyEventListener[] listeners = new TopologyEventListener[0];
    private List<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
    private final Object lock = new Object();
    private volatile TopologyViewImpl currentTopologyView;
    private volatile Map<String, String> cachedProperties = Collections.emptyMap();

    @Activate
    public NoClusterDiscoveryService(@Reference SlingSettingsService slingSettingsService, Config config) {
        this.logger.debug("NoClusterDiscoveryService started.");
        this.settingsService = slingSettingsService;
        this.alwaysOffline = config.always_offline();
        if (this.alwaysOffline) {
            this.logger.info("Discovery service configured to always report as offline");
        }
        this.createNewView(TopologyEvent.Type.TOPOLOGY_INIT, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        Object object = this.lock;
        synchronized (object) {
            this.currentTopologyView.invalidate();
            this.currentTopologyView = null;
            this.cachedProperties = null;
        }
        this.logger.debug("NoClusterDiscoveryService stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewView(TopologyEvent.Type eventType, boolean inform) {
        Object object = this.lock;
        synchronized (object) {
            TopologyViewImpl oldView;
            if (this.currentTopologyView != null) {
                this.currentTopologyView.invalidate();
                oldView = this.currentTopologyView;
            } else {
                oldView = null;
            }
            InstanceDescriptionImpl myInstanceDescription = new InstanceDescriptionImpl(this.settingsService.getSlingId(), this.cachedProperties);
            this.currentTopologyView = new TopologyViewImpl(myInstanceDescription);
            if (this.alwaysOffline) {
                this.currentTopologyView.invalidate();
            }
            TopologyEventListener[] registeredServices = this.listeners;
            TopologyViewImpl newView = this.currentTopologyView;
            if (inform && !this.alwaysOffline) {
                for (TopologyEventListener da : registeredServices) {
                    da.handleTopologyEvent(new TopologyEvent(eventType, (TopologyView)oldView, (TopologyView)newView));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, updated="updatedPropertyProvider")
    private void bindPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props) {
        this.logger.debug("Binding PropertyProvider {}", (Object)propertyProvider);
        Object object = this.lock;
        synchronized (object) {
            ProviderInfo info = new ProviderInfo(propertyProvider, props);
            this.providerInfos.add(info);
            Collections.sort(this.providerInfos);
            this.updatePropertiesCache();
        }
        this.createNewView(TopologyEvent.Type.PROPERTIES_CHANGED, true);
    }

    private void updatedPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props) {
        this.logger.debug("Updating PropertyProvider {}", (Object)propertyProvider);
        this.unbindPropertyProvider(propertyProvider, props, false);
        this.bindPropertyProvider(propertyProvider, props);
    }

    private void unbindPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props) {
        this.unbindPropertyProvider(propertyProvider, props, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindPropertyProvider(PropertyProvider propertyProvider, Map<String, Object> props, boolean inform) {
        this.logger.debug("Releasing PropertyProvider {}", (Object)propertyProvider);
        Object object = this.lock;
        synchronized (object) {
            ProviderInfo info = new ProviderInfo(propertyProvider, props);
            this.providerInfos.remove(info);
            this.updatePropertiesCache();
        }
        this.createNewView(TopologyEvent.Type.PROPERTIES_CHANGED, inform);
    }

    private void updatePropertiesCache() {
        HashMap<String, String> newProps = new HashMap<String, String>();
        for (ProviderInfo info : this.providerInfos) {
            newProps.putAll(info.properties);
        }
        this.cachedProperties = newProps;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("New properties: {}", this.cachedProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private void bindTopologyEventListener(TopologyEventListener listener) {
        this.logger.debug("Binding TopologyEventListener {}", (Object)listener);
        Object object = this.lock;
        synchronized (object) {
            ArrayList<TopologyEventListener> currentList = new ArrayList<TopologyEventListener>(Arrays.asList(this.listeners));
            currentList.add(listener);
            this.listeners = currentList.toArray(new TopologyEventListener[currentList.size()]);
        }
        if (!this.alwaysOffline) {
            listener.handleTopologyEvent(new TopologyEvent(TopologyEvent.Type.TOPOLOGY_INIT, null, (TopologyView)this.currentTopologyView));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindTopologyEventListener(TopologyEventListener listener) {
        this.logger.debug("Releasing TopologyEventListener {}", (Object)listener);
        Object object = this.lock;
        synchronized (object) {
            ArrayList<TopologyEventListener> currentList = new ArrayList<TopologyEventListener>(Arrays.asList(this.listeners));
            currentList.remove(listener);
            this.listeners = currentList.toArray(new TopologyEventListener[currentList.size()]);
        }
    }

    public TopologyView getTopology() {
        return this.currentTopologyView;
    }
}

