/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.distribution.DistributionRequestType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class DistributionPackageInfo
extends ValueMapDecorator
implements ValueMap {
    public static final String PROPERTY_PACKAGE_TYPE = "package.type";
    public static final String PROPERTY_REQUEST_PATHS = "request.paths";
    public static final String PROPERTY_REQUEST_DEEP_PATHS = "request.deepPaths";
    public static final String PROPERTY_REQUEST_TYPE = "request.type";

    public DistributionPackageInfo(String packageType, Map<String, Object> base) {
        super(base);
        if (packageType == null) {
            throw new IllegalArgumentException("package type cannot be null");
        }
        this.put(PROPERTY_PACKAGE_TYPE, packageType);
    }

    public DistributionPackageInfo(String packageType) {
        this(packageType, new HashMap<String, Object>());
    }

    @NotNull
    public String getType() {
        return (String)this.get(PROPERTY_PACKAGE_TYPE, String.class);
    }

    @Nullable
    public String[] getPaths() {
        return (String[])this.get(PROPERTY_REQUEST_PATHS, String[].class);
    }

    @Nullable
    public DistributionRequestType getRequestType() {
        return (DistributionRequestType)this.get(PROPERTY_REQUEST_TYPE, DistributionRequestType.class);
    }

    public String toString() {
        return "DistributionPackageInfo{ request.type=" + this.get(PROPERTY_REQUEST_TYPE, DistributionRequestType.class) + ", request.paths=" + Arrays.toString((Object[])this.get(PROPERTY_REQUEST_PATHS, String[].class)) + '}';
    }
}

