/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import relocated_for_contentpackage.javax.jcr.NamespaceException;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.ItemId;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.Name;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.NameFactory;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.NodeId;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.Path;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.QValue;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.QValueFactory;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.value.ValueFormat;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.observation.ObservationConstants;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.xml.DomUtil;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.xml.ElementIterator;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.xml.Namespace;

public class EventImpl
extends relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.EventImpl
implements ObservationConstants {
    private static Logger log = LoggerFactory.getLogger(EventImpl.class);
    private static final NameFactory N_FACTORY = NameFactoryImpl.getInstance();

    public EventImpl(ItemId eventId, Path eventPath, NodeId parentId, int eventType, String userId, Element eventElement, NamePathResolver resolver, QValueFactory qvFactory) throws NamespaceException, IllegalNameException {
        super(EventImpl.getSpiEventType(eventType), eventPath, eventId, parentId, EventImpl.getNameSafe(DomUtil.getChildTextTrim(eventElement, N_EVENTPRIMARYNODETYPE), resolver), EventImpl.getNames(DomUtil.getChildren(eventElement, N_EVENTMIXINNODETYPE), resolver), userId, DomUtil.getChildTextTrim(eventElement, N_EVENTUSERDATA), Long.parseLong(DomUtil.getChildTextTrim(eventElement, N_EVENTDATE)), EventImpl.getEventInfo(DomUtil.getChildElement(eventElement, N_EVENTINFO), resolver, qvFactory));
    }

    private static int getSpiEventType(int jcrEventType) {
        switch (jcrEventType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 16: {
                return 16;
            }
            case 8: {
                return 8;
            }
            case 32: {
                return 32;
            }
            case 64: {
                return 64;
            }
        }
        throw new IllegalArgumentException("Invalid event type: " + jcrEventType);
    }

    private static Map<Name, QValue> getEventInfo(Element infoElement, NamePathResolver resolver, QValueFactory qvFactory) {
        if (infoElement == null) {
            return Collections.emptyMap();
        }
        HashMap<Name, QValue> info = new HashMap<Name, QValue>();
        ElementIterator it = DomUtil.getChildren(infoElement);
        while (it.hasNext()) {
            Element el = it.nextElement();
            String uri = el.getNamespaceURI();
            if (uri == null) {
                uri = Namespace.EMPTY_NAMESPACE.getURI();
            }
            String localName = el.getLocalName();
            String value = DomUtil.getTextTrim(el);
            try {
                Name n = N_FACTORY.create(uri, localName);
                QValue qv = null;
                if (value != null) {
                    qv = ValueFormat.getQValue(value, 8, resolver, qvFactory);
                }
                info.put(n, qv);
            }
            catch (RepositoryException e) {
                log.error("Internal Error: {}", (Object)e.getMessage());
            }
        }
        return info;
    }

    private static Name getNameSafe(String name, NamePathResolver resolver) throws IllegalNameException, NamespaceException {
        if (name == null) {
            return null;
        }
        return resolver.getQName(name);
    }

    private static Name[] getNames(ElementIterator elements, NamePathResolver resolver) {
        List<Object> results = Collections.emptyList();
        while (elements.hasNext()) {
            String rawname = DomUtil.getText(elements.nextElement());
            Name name = null;
            try {
                name = resolver.getQName(rawname);
                if (results.size() == 0) {
                    results = Collections.singletonList(name);
                    continue;
                }
                if (results.size() == 1) {
                    results = new ArrayList<Object>(results);
                    results.add(name);
                    continue;
                }
                results.add(name);
            }
            catch (Exception ex) {
                log.error("Exception converting name " + rawname, (Throwable)ex);
            }
        }
        return results.toArray(new Name[results.size()]);
    }
}

