/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.browser;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.sling.ide.eclipse.ui.internal.SelectionUtils;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public abstract class AbstractOpenInBrowserHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        URL url;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        JcrNode node = SelectionUtils.getFirst(sel, JcrNode.class);
        if (node == null) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IModule module = ServerUtil.getModule((IProject)node.getProject());
        if (module == null) {
            MessageDialog.openWarning((Shell)shell, (String)"Cannot open browser", (String)"Not configured for any server");
            return null;
        }
        IServer[] servers = ServerUtil.getServersByModule((IModule)module, (IProgressMonitor)new NullProgressMonitor());
        if (servers == null || servers.length == 0) {
            MessageDialog.openWarning((Shell)shell, (String)"Cannot open browser", (String)"Not configured for any server");
            return null;
        }
        IServer server = servers[0];
        try {
            url = this.getUrlToOpen(node, server);
        }
        catch (MalformedURLException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.apache.sling.ide.eclipse-core", "Url is invalid", (Throwable)e), 2);
            return null;
        }
        try {
            IWorkbenchBrowserSupport browserSupport = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getWorkbench().getBrowserSupport();
            browserSupport.createBrowser("org.apache.sling.ide.openOnServer").openURL(url);
        }
        catch (PartInitException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.apache.sling.ide.eclipse-core", "Failed creating browser instance", (Throwable)e), 3);
        }
        return null;
    }

    protected abstract URL getUrlToOpen(JcrNode var1, IServer var2) throws MalformedURLException;
}

