/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.Tree;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.tree.AbstractTree;
import org.apache.jackrabbit.spi2dav.BatchUtils;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DocumentTree
extends AbstractTree {
    private final List<Property> properties = new ArrayList<Property>();

    protected DocumentTree(Name nodeName, Name ntName, String uniqueId, NamePathResolver resolver) {
        super(nodeName, ntName, uniqueId, resolver);
    }

    @Override
    protected Tree createChild(Name name, Name primaryTypeName, String uniqueId) {
        return new DocumentTree(name, primaryTypeName, uniqueId, this.getResolver());
    }

    @Override
    public void addProperty(NodeId parentId, Name propertyName, int propertyType, QValue value) throws RepositoryException {
        this.addProperty(parentId, propertyName, propertyType, new QValue[]{value});
    }

    @Override
    public void addProperty(NodeId parentId, Name propertyName, int propertyType, QValue[] values) throws RepositoryException {
        this.properties.add(new Property(propertyName, propertyType, values));
    }

    Document toDocument() throws RepositoryException {
        try {
            Document body = DomUtil.createDocument();
            this.buildNodeInfo(body, this);
            return body;
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException(e);
        }
    }

    private void buildNodeInfo(Node parent, DocumentTree tree) throws RepositoryException {
        Element node = BatchUtils.createNodeElement(parent, tree.getName(), tree.getPrimaryTypeName(), tree.getUniqueId(), this.getResolver());
        for (Property prop : this.properties) {
            BatchUtils.importProperty(node, prop.name, prop.type, prop.values, this.getResolver());
        }
        for (Tree child : tree.getChildren()) {
            this.buildNodeInfo(node, (DocumentTree)child);
        }
    }

    private static final class Property {
        private final Name name;
        private final int type;
        private final QValue[] values;

        private Property(Name name, int type, QValue[] values) {
            this.name = name;
            this.type = type;
            this.values = values;
        }
    }
}

