/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.AccessType;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.VaultFile;

public class VaultFileInputStream
extends InputStream {
    private final InputStream base;
    private Path tmpFile;

    public VaultFileInputStream(VaultFile file) throws IOException {
        block10: {
            Artifact a = file.getArtifact();
            if (a == null || a.getPreferredAccess() == AccessType.NONE) {
                throw new IOException("invalid access.");
            }
            try {
                if (a.getPreferredAccess() == AccessType.STREAM) {
                    this.base = a.getInputStream();
                    break block10;
                }
                this.tmpFile = Files.createTempFile("vltfs", ".spool", new FileAttribute[0]);
                try (OutputStream out = Files.newOutputStream(this.tmpFile, new OpenOption[0]);){
                    a.spool(out);
                }
                this.base = Files.newInputStream(this.tmpFile, new OpenOption[0]);
            }
            catch (RepositoryException e) {
                throw new IOException(e.toString());
            }
        }
    }

    @Override
    public int read() throws IOException {
        return this.base.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.base.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.base.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.base.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.base.available();
    }

    @Override
    public void close() throws IOException {
        this.base.close();
        if (this.tmpFile != null) {
            Files.delete(this.tmpFile);
            this.tmpFile = null;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.base.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.base.reset();
    }

    @Override
    public boolean markSupported() {
        return this.base.markSupported();
    }
}

