/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.ImportArtifact;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.ItemFilterSet;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.io.AbstractArtifactHandler;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.util.MimeTypes;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;

public class FileArtifactHandler
extends AbstractArtifactHandler {
    private String xmlNodeType = "nt:xmlDocument";
    private boolean explodeXml = false;

    public String getXmlNodeType() {
        return this.xmlNodeType;
    }

    public void setXmlNodeType(String xmlNodeType) {
        this.xmlNodeType = xmlNodeType;
    }

    public boolean isExplodeXml() {
        return this.explodeXml;
    }

    public void setExplodeXml(boolean explodeXml) {
        this.explodeXml = explodeXml;
    }

    @Override
    public ImportInfoImpl accept(@NotNull ImportOptions options, boolean isStrictByDefault, WorkspaceFilter wspFilter, Node parent, String name, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        ImportInfoImpl info = null;
        Collection<Artifact> removed = artifacts.removed();
        for (Artifact a : removed) {
            if (a.getType() != ArtifactType.FILE || !parent.hasNode(a.getRelativePath())) continue;
            Node node = parent.getNode(a.getRelativePath());
            String path = node.getPath();
            if (info == null) {
                info = new ImportInfoImpl();
            }
            if (wspFilter.getImportMode(path) == ImportMode.REPLACE) {
                info.onDeleted(path);
                node.remove();
                continue;
            }
            info.onNop(path);
        }
        if (artifacts.size(ArtifactType.FILE) > 0 || artifacts.size(ArtifactType.BINARY) > 0) {
            ImportMode mode;
            Artifact primary = artifacts.getPrimaryData();
            if (primary != null) {
                if (info == null) {
                    info = new ImportInfoImpl();
                }
                Object mode2 = ImportMode.REPLACE;
                String string = PathUtil.getPath(parent, primary.getRelativePath());
                if (primary.getRelativePath().length() == 0 || parent.hasNode(primary.getRelativePath())) {
                    mode2 = wspFilter.getImportMode(string);
                }
                if (mode2 != ImportMode.MERGE) {
                    VaultInputSource source = primary.getInputSource();
                    if (source != null) {
                        info.merge(this.importDocView(parent, source, artifacts, wspFilter, options));
                    }
                } else {
                    info.onNop(string);
                }
            }
            for (Artifact artifact : artifacts.values(ArtifactType.FILE)) {
                if (info == null) {
                    info = new ImportInfoImpl();
                }
                if (artifact.getSerializationType() == SerializationType.GENERIC || artifact.getSerializationType() == SerializationType.XML_GENERIC) {
                    String fileName = artifact.getRelativePath();
                    if (!parent.hasNode(fileName)) {
                        this.importFile(info, parent, artifact, fileName, false);
                        continue;
                    }
                    if (!(artifact instanceof ImportArtifact)) continue;
                    Node fileNode = parent.getNode(fileName);
                    ImportMode mode3 = wspFilter.getImportMode(fileNode.getPath());
                    if (mode3 != ImportMode.MERGE && mode3 != ImportMode.MERGE_PROPERTIES) {
                        if (!fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
                            fileNode.remove();
                            this.importFile(info, parent, artifact, fileName, parent.hasNode(fileName));
                            continue;
                        }
                        Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
                        if (this.isModifiedNtResource(contentNode)) {
                            contentNode.remove();
                            contentNode = fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "{http://www.jcp.org/jcr/nt/1.0}resource");
                            info.onReplaced(contentNode.getPath());
                        }
                        if (this.importNtResource(info, contentNode, artifact)) continue;
                        info.onNop(fileNode.getPath());
                        continue;
                    }
                    info.onNop(fileNode.getPath());
                    continue;
                }
                if (artifact.getSerializationType() == SerializationType.XML_DOCVIEW) {
                    String relPath = Text.getRelativeParent(artifact.getRelativePath(), 1);
                    String newName = Text.getName(artifact.getRelativePath());
                    Node newParent = parent;
                    if (relPath.length() > 0) {
                        if (parent.hasNode(relPath)) {
                            newParent = parent.getNode(relPath);
                        } else {
                            throw new IllegalArgumentException("Special docview file can't be imported. parent does not exist: " + parent.getPath() + "/" + relPath);
                        }
                    }
                    ArtifactSetImpl newSet = new ArtifactSetImpl();
                    newSet.setCoverage(ItemFilterSet.INCLUDE_ALL);
                    mode = ImportMode.REPLACE;
                    String path = PathUtil.getPath(newParent, newName);
                    if (newName.length() == 0 || newParent.hasNode(newName)) {
                        mode = wspFilter.getImportMode(path);
                    }
                    if (mode != ImportMode.MERGE) {
                        info.merge(this.importDocView(artifact.getInputSource(), newParent, newName, newSet, wspFilter, options.getIdConflictPolicy()));
                        continue;
                    }
                    info.onNop(path);
                    continue;
                }
                throw new IllegalArgumentException("Files of type " + (Object)((Object)artifact.getSerializationType()) + " can't be handled by this handler " + this);
            }
            ValueFactory factory = parent.getSession().getValueFactory();
            for (Artifact binary : artifacts.values(ArtifactType.BINARY)) {
                Node parentNode = parent;
                String path = binary.getRelativePath();
                int idx = path.lastIndexOf(47);
                if (idx > 0) {
                    parentNode = parent.getNode(path.substring(0, idx));
                    path = path.substring(idx + 1);
                }
                if ((mode = wspFilter.getImportMode(parentNode.getPath())) == ImportMode.MERGE || mode == ImportMode.MERGE_PROPERTIES) continue;
                Value value = factory.createValue(binary.getInputStream());
                if (parentNode.hasProperty(path) && value.equals(parentNode.getProperty(path).getValue())) continue;
                parent.setProperty(path, value);
                if (info == null) {
                    info = new ImportInfoImpl();
                }
                info.onModified(path);
                info.onModified(parentNode.getPath());
            }
        }
        return info;
    }

    private boolean isModifiedNtResource(Node content) throws RepositoryException {
        if (content.getMixinNodeTypes().length > 0) {
            return true;
        }
        if (content.isNodeType("{http://www.jcp.org/jcr/nt/1.0}resource")) {
            return false;
        }
        return content.hasNodes();
    }

    private void importFile(ImportInfo info, Node parent, Artifact primary, String name, boolean exists) throws RepositoryException, IOException {
        Node contentNode;
        if (exists) {
            Node fileNode = parent.getNode(name);
            if (!fileNode.isNodeType("nt:file")) {
                parent.getSession().refresh(false);
                throw new IOException("Incompatible content. Expected a nt:file but was " + fileNode.getPrimaryNodeType().getName());
            }
            contentNode = fileNode.getNode("jcr:content");
            info.onNop(fileNode.getPath());
        } else {
            Node fileNode = parent.addNode(name, "nt:file");
            String contentNodeType = primary.getSerializationType() == SerializationType.XML_GENERIC && this.isExplodeXml() ? this.getXmlNodeType() : "nt:resource";
            contentNode = fileNode.addNode("jcr:content", contentNodeType);
            info.onCreated(fileNode.getPath());
            info.onCreated(contentNode.getPath());
        }
        this.importNtResource(info, contentNode, primary);
    }

    private ImportInfoImpl importDocView(Node parent, InputSource source, ArtifactSetImpl artifacts, WorkspaceFilter wspFilter, ImportOptions options) throws RepositoryException, IOException {
        String rootName = artifacts.getPrimaryData().getRelativePath();
        int idx = rootName.indexOf(47);
        if (idx > 0) {
            rootName = rootName.substring(0, idx);
        }
        return this.importDocView(source, parent, rootName, artifacts, wspFilter, options.getIdConflictPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importNtResource(ImportInfo info, Node content, Artifact artifact) throws RepositoryException, IOException {
        String path = content.getPath();
        boolean modified = false;
        if (this.explodeXml && !content.isNodeType("nt:resource")) {
            try (InputStream in = artifact.getInputStream();){
                content.getSession().importXML(path, in, 0);
            }
            modified = true;
        } else {
            ValueFactory factory = content.getSession().getValueFactory();
            Value value = factory.createValue(artifact.getInputStream());
            if (!content.hasProperty("jcr:data") || !value.equals(content.getProperty("jcr:data").getValue())) {
                content.setProperty("jcr:data", value);
                modified = true;
            }
            if (!content.hasProperty("jcr:lastModified") || modified) {
                Calendar lastMod = Calendar.getInstance();
                content.setProperty("jcr:lastModified", lastMod);
                modified = true;
            }
            if (!content.hasProperty("jcr:mimeType")) {
                String mimeType = artifact.getContentType();
                if (mimeType == null) {
                    mimeType = Text.getName(artifact.getRelativePath(), '.');
                    mimeType = MimeTypes.getMimeType(mimeType, "application/octet-stream");
                }
                content.setProperty("jcr:mimeType", mimeType);
                modified = true;
            }
            if (content.isNew()) {
                info.onCreated(path + "/" + "jcr:data");
                info.onNop(path);
            } else if (modified) {
                info.onModified(path + "/" + "jcr:data");
                info.onModified(path);
            }
        }
        return modified;
    }
}

