/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt.serialization;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.Mounter;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import org.apache.jackrabbit.vault.fs.io.DocViewParser;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.jackrabbit.vault.util.RepositoryProvider;
import org.apache.sling.ide.impl.vlt.VaultFsLocator;
import org.apache.sling.ide.impl.vlt.serialization.ResourceProxyParserHandler;
import org.apache.sling.ide.impl.vlt.serialization.VltSerializationDataBuilder;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.serialization.SerializationDataBuilder;
import org.apache.sling.ide.serialization.SerializationException;
import org.apache.sling.ide.serialization.SerializationKind;
import org.apache.sling.ide.serialization.SerializationManager;
import org.apache.sling.ide.sync.content.WorkspaceDirectory;
import org.apache.sling.ide.sync.content.WorkspaceFile;
import org.apache.sling.ide.sync.content.WorkspacePath;
import org.apache.sling.ide.sync.content.WorkspaceProject;
import org.apache.sling.ide.sync.content.WorkspaceResource;
import org.apache.sling.ide.transport.RepositoryPath;
import org.apache.sling.ide.transport.ResourceProxy;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.xml.sax.InputSource;

@Component(service={SerializationManager.class})
public class VltSerializationManager
implements SerializationManager {
    static final String EXTENSION_XML = ".xml";
    private final Logger logger;
    private final VaultFsLocator fsLocator;

    public static void main(String[] args) throws RepositoryException, URISyntaxException, IOException {
        VaultFile vaultFile;
        String[] attempts;
        RepositoryAddress address = new RepositoryAddress("http://localhost:8080/server/root");
        Repository repo = new RepositoryProvider().getRepository(address);
        Session session = repo.login(new SimpleCredentials("admin", "admin".toCharArray()));
        VaultFileSystem fs = Mounter.mount(null, null, address, "/", session);
        for (String string : attempts = new String[]{"/rep:policy", "/var"}) {
            vaultFile = fs.getFile(string);
            System.out.println(string + " -> " + String.valueOf(vaultFile));
        }
        for (String string : attempts) {
            String string2 = PlatformNameFormat.getPlatformPath(string) + EXTENSION_XML;
            vaultFile = fs.getFile(string2);
            System.out.println(string2 + " -> " + String.valueOf(vaultFile));
        }
    }

    @Activate
    public VltSerializationManager(@Reference Logger logger, @Reference VaultFsLocator fsLocator) {
        this.logger = logger;
        this.fsLocator = fsLocator;
    }

    public void destroy() {
    }

    public boolean isSerializationFile(WorkspaceFile file) {
        boolean bl;
        block10: {
            String fileName = file.getName();
            if (fileName.equals(".content.xml")) {
                return true;
            }
            if (!fileName.endsWith(EXTENSION_XML)) {
                return false;
            }
            InputStream in = file.getContents();
            try {
                bl = DocViewParser.isDocView(new InputSource(in));
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return bl;
    }

    public WorkspaceFile getSerializationFile(WorkspaceResource resource, SerializationKind serializationKind) {
        switch (serializationKind) {
            case FOLDER: 
            case METADATA_PARTIAL: {
                WorkspacePath path = resource.getLocalPath();
                WorkspacePath projectRelativePath = resource.getProject().getLocalPath().relativize(path);
                return resource.getProject().getDirectory(projectRelativePath).getFile(new WorkspacePath(".content.xml"));
            }
            case METADATA_FULL: {
                return (WorkspaceFile)resource;
            }
            case FILE: {
                WorkspaceProject project = resource.getProject();
                WorkspaceDirectory parentDir = project.getDirectory(resource.getLocalPath().getParent());
                return parentDir.getDirectory(new WorkspacePath(resource.getName() + ".dir")).getFile(new WorkspacePath(".content.xml"));
            }
        }
        throw new IllegalArgumentException("Unsupported serialization kind " + String.valueOf(serializationKind));
    }

    public RepositoryPath getRepositoryPath(WorkspacePath localPath) {
        Object repositoryPath;
        String osPath = localPath.asPortableString();
        String name = Text.getName(osPath);
        if (name.equals(".content.xml")) {
            String parentPath = Text.getRelativeParent(osPath, 1);
            if (parentPath != null && parentPath.endsWith(".dir")) {
                parentPath = parentPath.substring(0, parentPath.length() - ".dir".length());
            }
            repositoryPath = PlatformNameFormat.getRepositoryPath(parentPath);
        } else {
            repositoryPath = osPath.endsWith(EXTENSION_XML) ? PlatformNameFormat.getRepositoryPath(osPath.substring(0, osPath.length() - EXTENSION_XML.length())) : PlatformNameFormat.getRepositoryPath(osPath).replace(".dir/", "/");
        }
        if (((String)repositoryPath).length() > 0 && ((String)repositoryPath).charAt(0) != '/') {
            repositoryPath = "/" + (String)repositoryPath;
        } else if (((String)repositoryPath).length() == 0) {
            repositoryPath = "/";
        }
        return new RepositoryPath((String)repositoryPath);
    }

    public String getLocalName(String repositoryName) {
        if (repositoryName == null || repositoryName.contains("/")) {
            throw new IllegalArgumentException("Repository name must not be null or contain slashes : " + repositoryName);
        }
        return PlatformNameFormat.getPlatformName(repositoryName);
    }

    public SerializationDataBuilder newBuilder(org.apache.sling.ide.transport.Repository repository, File contentSyncRoot) throws SerializationException {
        VltSerializationDataBuilder b = new VltSerializationDataBuilder(this.logger, this.fsLocator);
        b.init(repository, contentSyncRoot);
        return b;
    }

    public ResourceProxy readSerializationData(WorkspaceFile file) throws IOException {
        ResourceProxy resourceProxy;
        block9: {
            if (file == null || !file.exists()) {
                return null;
            }
            RepositoryPath repositoryPath = this.getRepositoryPath(file.getPathRelativeToSyncDir());
            InputStream source = file.getContents();
            try {
                DocViewParser parser = new DocViewParser();
                ResourceProxyParserHandler handler = new ResourceProxyParserHandler();
                parser.parse(repositoryPath.asString(), new InputSource(source), handler);
                resourceProxy = handler.getRoot();
                if (source == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DocViewParser.XmlParseException e) {
                    throw new IOException(e);
                }
            }
            source.close();
        }
        return resourceProxy;
    }
}

