/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.oak.server.internal.index;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneIndexHelper;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.sling.jcr.oak.server.internal.index.LuceneIndexRepositoryInitializerConfiguration;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Apache Sling JCR Oak Repository \u2013 Lucene Index Definition"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=LuceneIndexRepositoryInitializerConfiguration.class)
public class LuceneIndexRepositoryInitializer
implements RepositoryInitializer {
    private LuceneIndexRepositoryInitializerConfiguration configuration;
    private final Logger logger = LoggerFactory.getLogger(LuceneIndexRepositoryInitializer.class);

    @Activate
    private void activate(LuceneIndexRepositoryInitializerConfiguration configuration) {
        this.logger.debug("activating");
        this.configuration = configuration;
    }

    public void initialize(@NotNull NodeBuilder root) {
        NodeBuilder index;
        this.logger.debug("initializing");
        if (root.hasChildNode("oak:index") && !(index = root.child("oak:index")).hasChildNode(this.configuration.name())) {
            this.logger.debug("adding new Lucene index definition");
            LuceneIndexHelper.newLuceneIndexDefinition((NodeBuilder)index, (String)this.configuration.name(), new HashSet<String>(Arrays.asList(this.configuration.includePropertyTypes())), new HashSet<String>(Arrays.asList(this.configuration.excludePropertyNames())), (String)"async");
        }
    }
}

