/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet.junit5;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.runner.Description;

public enum DescriptionGenerator {
    CLASS_SOURCE(ClassSource.class, src -> Description.createSuiteDescription(src.getJavaClass())),
    METHOD_SOURCE(MethodSource.class, src -> Description.createTestDescription(src.getClassName(), src.getMethodName(), new Annotation[0]));

    private final Class<? extends TestSource> clazz;
    private final Function<? super TestSource, Description> generator;

    private <T extends TestSource> DescriptionGenerator(Class<T> clazz, Function<? super T, Description> generator) {
        this.clazz = clazz;
        this.generator = generator;
    }

    @NotNull
    public static Optional<Description> toDescription(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().map(DescriptionGenerator::createDescription);
    }

    static Description createDescription(TestSource testSource) {
        if (testSource != null) {
            return Arrays.stream(DescriptionGenerator.values()).filter(v -> v.clazz.isInstance(testSource)).map(v -> v.generator.apply((TestSource)testSource)).findFirst().orElse(null);
        }
        return null;
    }
}

