/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.params;

import java.util.Collections;
import java.util.Map;
import org.apache.sling.resourceresolver.impl.params.ParametersParser;

class PathParser {
    private String rawPath;
    private String parametersString;
    private Map<String, String> parameters;

    PathParser() {
    }

    public String getPath() {
        return this.rawPath;
    }

    public String getParametersString() {
        return this.parametersString;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void parse(String path) {
        int i;
        this.rawPath = path;
        this.parameters = Collections.emptyMap();
        if (path == null) {
            return;
        }
        int si = path.indexOf(59);
        if (si == -1) {
            return;
        }
        int di = path.indexOf(46);
        char[] chars = path.toCharArray();
        ParametersParser parametersParser = new ParametersParser();
        ParserState state = ParserState.INIT;
        int paramsStart = -1;
        int paramsEnd = -1;
        int n = di != -1 ? (si != -1 ? Math.min(di, si) : di) : (i = si);
        while (i <= chars.length) {
            char c = i == chars.length ? (char)'\u0000' : chars[i];
            switch (state) {
                case INIT: {
                    if (c == '.') {
                        state = ParserState.V1_EXTENSION;
                        break;
                    }
                    if (c != ';') break;
                    paramsStart = i;
                    i = parametersParser.parseParameters(chars, i, false);
                    paramsEnd = i--;
                    state = parametersParser.isInvalid() ? ParserState.INVALID : ParserState.V2_PARAMS;
                    break;
                }
                case V1_EXTENSION: {
                    if (c == '/') {
                        state = ParserState.SUFFIX;
                        break;
                    }
                    if (c != ';') break;
                    paramsStart = i;
                    i = parametersParser.parseParameters(chars, i, true);
                    paramsEnd = i--;
                    state = parametersParser.isInvalid() ? ParserState.INVALID : ParserState.V1_PARAMS;
                    break;
                }
                case V1_PARAMS: {
                    if (c == '/') {
                        state = ParserState.SUFFIX;
                        break;
                    }
                    if (c != '.') break;
                    state = ParserState.INVALID;
                    break;
                }
                case V2_PARAMS: {
                    if (c == '/') {
                        state = ParserState.INVALID;
                        break;
                    }
                    if (c != '.') break;
                    state = ParserState.V2_EXTENSION;
                    break;
                }
                case V2_EXTENSION: {
                    if (c != '/') break;
                    state = ParserState.SUFFIX;
                    break;
                }
            }
            ++i;
        }
        if (state == ParserState.INVALID) {
            paramsEnd = -1;
            paramsStart = -1;
        } else {
            this.cutPath(path, paramsStart, paramsEnd);
            this.parameters = Collections.unmodifiableMap(parametersParser.getParameters());
        }
    }

    private void cutPath(String path, int from, int to) {
        if (from == -1) {
            this.rawPath = path;
            this.parametersString = null;
        } else if (to == -1) {
            this.rawPath = path.substring(0, from);
            this.parametersString = path.substring(from);
        } else {
            this.rawPath = path.substring(0, from) + path.substring(to);
            this.parametersString = path.substring(from, to);
        }
    }

    private static enum ParserState {
        INIT,
        V1_EXTENSION,
        V1_PARAMS,
        V2_PARAMS,
        V2_EXTENSION,
        SUFFIX,
        INVALID;

    }
}

