/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.apache.sling.testing.resourceresolver.MockPropertyResource;
import org.apache.sling.testing.resourceresolver.MockQueryLanguageProvider;
import org.apache.sling.testing.resourceresolver.MockResource;
import org.apache.sling.testing.resourceresolver.MockResourceResolver;
import org.apache.sling.testing.resourceresolver.MockResourceResolverFactory;
import org.apache.sling.testing.resourceresolver.MockResourceResolverFactoryOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.event.EventAdmin;

@Component(service={ResourceProvider.class}, property={"provider.name=MockResourceProvider", "provider.root=/", "provider.modifiable:Boolean=true", "provider.adaptable:Boolean=true", "provider.authenticate=required"})
public final class MockResourceProvider
extends ResourceProvider<Void> {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private EventAdmin eventAdmin;
    private MockResourceResolver mockResourceResolver;
    private MockQueryLanguageProvider mockQueryLanguageProvider;

    @Activate
    private void activate() {
        MockResourceResolverFactoryOptions options = new MockResourceResolverFactoryOptions();
        options.setMangleNamespacePrefixes(true);
        options.setEventAdmin(this.eventAdmin);
        MockResourceResolverFactory resourceResolverFactory = new MockResourceResolverFactory(options);
        try {
            this.mockResourceResolver = (MockResourceResolver)resourceResolverFactory.getResourceResolver(null);
        }
        catch (LoginException ex) {
            throw new RuntimeException(ex);
        }
        this.mockQueryLanguageProvider = new MockQueryLanguageProvider(this.mockResourceResolver);
    }

    @Nullable
    public Resource getResource(@NotNull ResolveContext<Void> ctx, @NotNull String path, @NotNull ResourceContext resourceContext, @Nullable Resource parent) {
        Resource resource = this.mockResourceResolver.getResource(path);
        if (resource != null) {
            return this.attachResource(ctx, resource);
        }
        return null;
    }

    @Nullable
    public Iterator<Resource> listChildren(@NotNull ResolveContext<Void> ctx, @NotNull Resource parent) {
        Iterator<Resource> children = this.mockResourceResolver.listChildren(parent);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(children, 16), false).map(resource -> this.attachResource(ctx, (Resource)resource)).iterator();
    }

    @NotNull
    public Resource create(@NotNull ResolveContext<Void> ctx, String path, Map<String, Object> properties) throws PersistenceException {
        String parentPath = ResourceUtil.getParent((String)path);
        String name = ResourceUtil.getName((String)path);
        if (parentPath == null) {
            throw new PersistenceException("Invalid path: " + path);
        }
        Resource parent = this.mockResourceResolver.getResource(parentPath);
        if (parent == null) {
            throw new PersistenceException("Parent does not exist: " + parentPath);
        }
        Resource newResource = this.mockResourceResolver.create(parent, name, properties);
        return this.attachResource(ctx, newResource);
    }

    public void delete(@NotNull ResolveContext<Void> ctx, @NotNull Resource resource) throws PersistenceException {
        this.mockResourceResolver.delete(resource);
    }

    public void revert(@NotNull ResolveContext<Void> ctx) {
        this.mockResourceResolver.revert();
    }

    public void commit(@NotNull ResolveContext<Void> ctx) throws PersistenceException {
        this.mockResourceResolver.commit();
    }

    public boolean hasChanges(@NotNull ResolveContext<Void> ctx) {
        return this.mockResourceResolver.hasChanges();
    }

    @Nullable
    public QueryLanguageProvider<Void> getQueryLanguageProvider() {
        return this.mockQueryLanguageProvider;
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull ResolveContext<Void> ctx, @NotNull Class<AdapterType> type) {
        if (type == MockResourceResolver.class) {
            return (AdapterType)((Object)this.mockResourceResolver);
        }
        return (AdapterType)super.adaptTo(ctx, type);
    }

    @NotNull
    private Resource attachResource(@NotNull ResolveContext<Void> ctx, @NotNull Resource resource) {
        if (resource instanceof MockResource) {
            return ((MockResource)resource).forResourceProvider(ctx.getResourceResolver());
        }
        if (resource instanceof MockPropertyResource) {
            return ((MockPropertyResource)resource).forResourceProvider(ctx.getResourceResolver());
        }
        return resource;
    }
}

