/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.iterators.LazyIteratorChain;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.commons.collections.ListUtils;
import org.apache.jackrabbit.oak.commons.collections.StreamUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.jetbrains.annotations.NotNull;

public class IterableUtils {
    private IterableUtils() {
    }

    public static <E> Iterable<E> chainedIterable(Iterable<? extends E> a, Iterable<? extends E> b) {
        return org.apache.commons.collections4.IterableUtils.chainedIterable(a, b);
    }

    public static <E> Iterable<E> chainedIterable(Iterable<? extends E> a, Iterable<? extends E> b, Iterable<? extends E> c) {
        return org.apache.commons.collections4.IterableUtils.chainedIterable(a, b, c);
    }

    public static <E> Iterable<E> chainedIterable(Iterable<? extends E> a, Iterable<? extends E> b, Iterable<? extends E> c, Iterable<? extends E> d) {
        return org.apache.commons.collections4.IterableUtils.chainedIterable(a, b, c, d);
    }

    @SafeVarargs
    public static <E> Iterable<E> chainedIterable(Iterable<? extends E> ... iterables) {
        Objects.requireNonNull(iterables);
        return org.apache.commons.collections4.IterableUtils.chainedIterable((Iterable[])iterables);
    }

    public static <E> Iterable<E> chainedIterable(final Iterable<? extends Iterable<? extends E>> iterables) {
        Objects.requireNonNull(iterables);
        return () -> new LazyIteratorChain<E>(){
            private final Iterator iterator;
            {
                this.iterator = iterables.iterator();
            }

            protected Iterator<? extends E> nextIterator(int count) {
                return this.iterator.hasNext() ? ((Iterable)this.iterator.next()).iterator() : null;
            }
        };
    }

    public static <E> boolean contains(Iterable<E> iterable, Object object) {
        return org.apache.commons.collections4.IterableUtils.contains(iterable, (Object)object);
    }

    public static int size(Iterable<?> itr) {
        return org.apache.commons.collections4.IterableUtils.size(itr);
    }

    public static <E> boolean matchesAll(Iterable<E> itr, Predicate<? super E> predicate) {
        return org.apache.commons.collections4.IterableUtils.matchesAll(itr, predicate::test);
    }

    public static boolean isEmpty(Iterable<?> itr) {
        return org.apache.commons.collections4.IterableUtils.isEmpty(itr);
    }

    @NotNull
    public static <T> T[] toArray(Iterable<T> itr, Class<T> type) {
        Object[] t = (Object[])Array.newInstance(type, 0);
        List<Object> collection = itr instanceof Collection ? (List<Object>)itr : ListUtils.toList(itr);
        return collection.toArray(t);
    }

    public static <T> Iterable<List<T>> partition(final Iterable<T> itr, final int size) {
        Objects.requireNonNull(itr, "Iterable must not be null.");
        Validate.checkArgument(size > 0, "Size must be greater than 0.");
        return new Iterable<List<T>>(){

            @Override
            @NotNull
            public Iterator<List<T>> iterator() {
                return IteratorUtils.partition(itr.iterator(), size);
            }
        };
    }

    public static <E> Iterable<E> filter(Iterable<E> itr, Predicate<? super E> predicate) {
        return org.apache.commons.collections4.IterableUtils.filteredIterable(itr, predicate::test);
    }

    public static <E> Iterable<E> filter(Iterable<?> itr, Class<E> type) {
        return StreamUtils.toStream(itr).filter(type::isInstance).collect(Collectors.toList());
    }

    public static <I, O> Iterable<O> transform(Iterable<I> iterable, Function<? super I, ? extends O> function) {
        return org.apache.commons.collections4.IterableUtils.transformedIterable(iterable, function::apply);
    }

    public static <T> Iterable<T> mergeSorted(Iterable<? extends Iterable<? extends T>> iterables, Comparator<? super T> c) {
        Objects.requireNonNull(iterables, "Iterables must not be null.");
        Objects.requireNonNull(c, "Comparator must not be null.");
        Iterable iterable = () -> IteratorUtils.mergeSorted(org.apache.commons.collections4.IterableUtils.transformedIterable((Iterable)iterables, Iterable::iterator), c);
        return org.apache.commons.collections4.IterableUtils.unmodifiableIterable(iterable);
    }

    public static boolean elementsEqual(Iterable<?> itr1, Iterable<?> itr2) {
        if (itr1 == itr2) {
            return true;
        }
        if (itr1 == null || itr2 == null) {
            return false;
        }
        if (itr1 instanceof Collection && itr2 instanceof Collection) {
            Collection c1 = (Collection)itr1;
            Collection c2 = (Collection)itr2;
            if (c1.size() != c2.size()) {
                return false;
            }
        }
        return IteratorUtils.elementsEqual(itr1.iterator(), itr2.iterator());
    }

    public static <T> Iterable<T> limit(Iterable<T> iterable, int limitSize) {
        return org.apache.commons.collections4.IterableUtils.boundedIterable(iterable, (long)limitSize);
    }

    public static String toString(Iterable<?> iterable) {
        return org.apache.commons.collections4.IterableUtils.toString(iterable);
    }

    public static <T> T getFirst(Iterable<T> iterable, T defaultValue) {
        Objects.requireNonNull(iterable, "Iterable must not be null.");
        Iterator<T> iterator = iterable.iterator();
        return iterator.hasNext() ? iterator.next() : defaultValue;
    }

    public static <T> T get(Iterable<T> iterable, int index) {
        Objects.requireNonNull(iterable, "Iterable must not be null.");
        return (T)org.apache.commons.collections4.IterableUtils.get(iterable, (int)index);
    }

    public static <T> T find(Iterable<T> iterable, Predicate<? super T> predicate) {
        Objects.requireNonNull(iterable, "Iterable must not be null.");
        Objects.requireNonNull(predicate, "Predicate must not be null.");
        return (T)org.apache.commons.collections4.IterableUtils.find(iterable, predicate::test);
    }

    public static <T> T getLast(Iterable<T> iterable) {
        Objects.requireNonNull(iterable, "Iterable must not be null.");
        if (iterable instanceof List) {
            List list = (List)iterable;
            return list.isEmpty() ? null : (T)list.get(list.size() - 1);
        }
        T last = null;
        for (T element : iterable) {
            last = element;
        }
        return last;
    }
}

