/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.progress;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounter;
import org.apache.jackrabbit.oak.plugins.index.progress.NodeCountEstimator;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeCounterMBeanEstimator
implements NodeCountEstimator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NodeCounter counter;
    private final NodeStore nodeStore;

    public NodeCounterMBeanEstimator(NodeStore nodeStore) {
        this(nodeStore, new NodeCounter(nodeStore));
    }

    NodeCounterMBeanEstimator(NodeStore nodeStore, NodeCounter nodeCounter) {
        this.nodeStore = nodeStore;
        this.counter = nodeCounter;
    }

    @Override
    public long getEstimatedNodeCount(String basePath, Set<String> indexPaths) {
        long estimate;
        PathPerimeter pp = new PathPerimeter();
        pp.compute(basePath, indexPaths);
        if (pp.includeAll) {
            return this.counter.getEstimatedNodeCount(basePath);
        }
        long totalCount = 0L;
        for (String path : pp.includes) {
            estimate = this.counter.getEstimatedNodeCount(path);
            if (estimate <= 0L) continue;
            totalCount += estimate;
        }
        for (String path : pp.excludes) {
            estimate = this.counter.getEstimatedNodeCount(path);
            if (estimate <= 0L) continue;
            totalCount -= estimate;
        }
        this.log.info("Paths to be traversed {}", (Object)pp);
        return totalCount;
    }

    private class PathPerimeter {
        final Set<String> includes = new HashSet<String>();
        final Set<String> excludes = new HashSet<String>();
        boolean includeAll;

        private PathPerimeter() {
        }

        public void compute(String basePath, Set<String> indexPaths) {
            NodeState root = NodeCounterMBeanEstimator.this.nodeStore.getRoot();
            for (String indexPath : indexPaths) {
                NodeState idxState = NodeStateUtils.getNode(root, indexPath);
                if (!idxState.hasProperty("includedPaths") && !idxState.hasProperty("excludedPaths")) {
                    this.includeAll = true;
                    return;
                }
                PathFilter.getStrings(idxState.getProperty("includedPaths"), Set.of()).forEach(this.includes::add);
                PathFilter.getStrings(idxState.getProperty("excludedPaths"), Set.of()).forEach(this.excludes::add);
            }
            if (this.includes.isEmpty()) {
                this.includes.add(basePath);
            }
            PathUtils.unifyInExcludes(this.includes, this.excludes);
        }

        public String toString() {
            return String.format("includedPath : %s, excludedPaths : %s", this.includes, this.excludes);
        }
    }
}

