/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ValuePattern {
    public static final ValuePattern MATCH_ALL = new ValuePattern();
    private final Pattern pattern;
    private final Iterable<String> includePrefixes;
    private final Iterable<String> excludePrefixes;

    public ValuePattern(NodeBuilder node) {
        this(node.getString("valuePattern"), ValuePattern.getStrings(node, "valueIncludedPrefixes"), ValuePattern.getStrings(node, "valueExcludedPrefixes"));
    }

    public ValuePattern(NodeState node) {
        this(node.getString("valuePattern"), ValuePattern.getStrings(node, "valueIncludedPrefixes"), ValuePattern.getStrings(node, "valueExcludedPrefixes"));
    }

    public ValuePattern() {
        this(null, null, null);
    }

    public ValuePattern(String pattern, Iterable<String> includePrefixes, Iterable<String> excludePrefixes) {
        Pattern p = pattern == null ? null : Pattern.compile(pattern);
        this.includePrefixes = includePrefixes;
        this.excludePrefixes = excludePrefixes;
        this.pattern = p;
    }

    public boolean matches(String v) {
        if (this.matchesAll() || v == null) {
            return true;
        }
        if (this.includePrefixes != null) {
            for (String inc : this.includePrefixes) {
                if (!v.startsWith(inc)) continue;
                return true;
            }
        }
        if (this.excludePrefixes != null) {
            for (String exc : this.excludePrefixes) {
                if (!v.startsWith(exc) && !exc.startsWith(v)) continue;
                return false;
            }
        }
        if (this.includePrefixes != null && this.pattern == null) {
            return false;
        }
        return this.pattern == null || this.pattern.matcher(v).matches();
    }

    public boolean matchesAll() {
        return this.includePrefixes == null && this.excludePrefixes == null && this.pattern == null;
    }

    public static Iterable<String> getStrings(NodeBuilder node, String propertyName) {
        if (!node.hasProperty(propertyName)) {
            return null;
        }
        PropertyState s = node.getProperty(propertyName);
        if (s.isArray()) {
            return node.getProperty(propertyName).getValue(Type.STRINGS);
        }
        return Collections.singleton(node.getString(propertyName));
    }

    public static Iterable<String> getStrings(NodeState node, String propertyName) {
        if (!node.hasProperty(propertyName)) {
            return null;
        }
        PropertyState s = node.getProperty(propertyName);
        if (s.isArray()) {
            return node.getStrings(propertyName);
        }
        return Collections.singleton(node.getString(propertyName));
    }

    public boolean matchesAll(Set<String> values) {
        if (this.matchesAll() || values == null) {
            return true;
        }
        for (String v : values) {
            if (this.matches(v)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesPrefix(String prefix) {
        if (this.pattern != null) {
            return false;
        }
        if (this.includePrefixes == null && this.excludePrefixes == null) {
            return true;
        }
        if (prefix == null || prefix.isEmpty()) {
            return false;
        }
        if (this.includePrefixes != null) {
            for (String inc : this.includePrefixes) {
                if (!prefix.startsWith(inc)) continue;
                return true;
            }
            return false;
        }
        if (this.excludePrefixes != null) {
            for (String exc : this.excludePrefixes) {
                if (!prefix.startsWith(exc) && !exc.startsWith(prefix)) continue;
                return false;
            }
        }
        return true;
    }
}

