/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import java.util.List;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.oak.plugins.value.jcr.PartialValueFactory;

class PropertyDefinitionImpl
extends ItemDefinitionImpl
implements PropertyDefinition {
    private static final Value[] NO_VALUES = new Value[0];

    PropertyDefinitionImpl(Tree definition, NodeType type, NamePathMapper mapper) {
        super(definition, type, mapper);
    }

    public static int valueFromName(String name) {
        Type<?> type = Type.fromString(name);
        if (type.isArray()) {
            throw new IllegalStateException("unknown property type: " + name);
        }
        return type.tag();
    }

    public int getRequiredType() {
        String string = this.getString("jcr:requiredType");
        if (string != null) {
            return PropertyDefinitionImpl.valueFromName(string);
        }
        return 0;
    }

    public String[] getValueConstraints() {
        String[] valConstraints = this.getStrings("jcr:valueConstraints");
        if (valConstraints != null) {
            return valConstraints;
        }
        return new String[0];
    }

    public Value[] getDefaultValues() {
        PropertyState property = this.definition.getProperty("jcr:defaultValues");
        if (property == null) {
            return null;
        }
        if (property.isArray()) {
            List<Value> values = new PartialValueFactory(this.mapper).createValues(property);
            return values.toArray(NO_VALUES);
        }
        Value value = new PartialValueFactory(this.mapper).createValue(property);
        return new Value[]{value};
    }

    public boolean isMultiple() {
        return this.getBoolean("jcr:multiple");
    }

    public String[] getAvailableQueryOperators() {
        String[] operators = this.getStrings("jcr:availableQueryOperators");
        if (operators == null) {
            operators = new String[]{"jcr.operator.equal.to", "jcr.operator.not.equal.to", "jcr.operator.greater.than", "jcr.operator.greater.than.or.equal.to", "jcr.operator.less.than", "jcr.operator.less.than.or.equal.to", "jcr.operator.like"};
        }
        return operators;
    }

    public boolean isFullTextSearchable() {
        return this.getBoolean("jcr:isFullTextSearchable");
    }

    public boolean isQueryOrderable() {
        return this.getBoolean("jcr:isQueryOrderable");
    }
}

