/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.monitor;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.security.user.monitor.UserMonitor;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.jetbrains.annotations.NotNull;

public class UserMonitorImpl
implements UserMonitor {
    private static final String ADD_MEMBERS_FAILED = "security.user.add_members.failed";
    private static final String ADD_MEMBERS_SUCCEEDED = "security.user.add_members.succeeded";
    private static final String ADD_MEMBERS_TIMER = "security.user.add_members.timer";
    private static final String REMOVE_MEMBERS_FAILED = "security.user.remove_members.failed";
    private static final String REMOVE_MEMBERS_SUCCEEDED = "security.user.remove_members.succeeded";
    private static final String REMOVE_MEMBERS_TIMER = "security.user.remove_members.timer";
    private static final String GET_MEMBERS_TIMER = "security.user.get_members.timer";
    private static final String GET_DECLARED_MEMBERS_TIMER = "security.user.get_declared_members.timer";
    private static final String MEMBEROF_TIMER = "security.user.memberof.timer";
    private static final String DECLARED_MEMBEROF_TIMER = "security.user.declared_memberof.timer";
    private final MeterStats addMembersFailed;
    private final MeterStats addMembersSucceeded;
    private final TimerStats addMembersTimer;
    private final MeterStats removeMembersFailed;
    private final MeterStats removeMembersSucceeded;
    private final TimerStats removeMembersTimer;
    private final TimerStats getMembersTimer;
    private final TimerStats getDeclaredMembersTimer;
    private final TimerStats memberOfTimer;
    private final TimerStats declaredMemberOfTimer;

    public UserMonitorImpl(@NotNull StatisticsProvider statisticsProvider) {
        this.addMembersFailed = statisticsProvider.getMeter(ADD_MEMBERS_FAILED, StatsOptions.DEFAULT);
        this.addMembersSucceeded = statisticsProvider.getMeter(ADD_MEMBERS_SUCCEEDED, StatsOptions.DEFAULT);
        this.addMembersTimer = statisticsProvider.getTimer(ADD_MEMBERS_TIMER, StatsOptions.METRICS_ONLY);
        this.removeMembersFailed = statisticsProvider.getMeter(REMOVE_MEMBERS_FAILED, StatsOptions.DEFAULT);
        this.removeMembersSucceeded = statisticsProvider.getMeter(REMOVE_MEMBERS_SUCCEEDED, StatsOptions.DEFAULT);
        this.removeMembersTimer = statisticsProvider.getTimer(REMOVE_MEMBERS_TIMER, StatsOptions.METRICS_ONLY);
        this.getMembersTimer = statisticsProvider.getTimer(GET_MEMBERS_TIMER, StatsOptions.METRICS_ONLY);
        this.getDeclaredMembersTimer = statisticsProvider.getTimer(GET_DECLARED_MEMBERS_TIMER, StatsOptions.METRICS_ONLY);
        this.memberOfTimer = statisticsProvider.getTimer(MEMBEROF_TIMER, StatsOptions.METRICS_ONLY);
        this.declaredMemberOfTimer = statisticsProvider.getTimer(DECLARED_MEMBEROF_TIMER, StatsOptions.METRICS_ONLY);
    }

    @Override
    public void doneGetMembers(long timeTakenNanos, boolean declaredOnly) {
        if (declaredOnly) {
            this.getMembersTimer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
        } else {
            this.getDeclaredMembersTimer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void doneMemberOf(long timeTakenNanos, boolean declaredOnly) {
        if (declaredOnly) {
            this.declaredMemberOfTimer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
        } else {
            this.memberOfTimer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void doneUpdateMembers(long timeTakenNanos, long totalProcessed, long failed, boolean isRemove) {
        long successCnt = totalProcessed - failed;
        if (isRemove) {
            this.removeMembersFailed.mark(failed);
            this.removeMembersSucceeded.mark(successCnt);
            this.removeMembersTimer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
        } else {
            this.addMembersFailed.mark(failed);
            this.addMembersSucceeded.mark(successCnt);
            this.addMembersTimer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
        }
    }
}

