/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.binder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.RuleSet;
import org.apache.commons.digester3.binder.AbstractBackToLinkedRuleBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FromBinderRuleSet
implements RuleSet {
    private final Collection<AbstractBackToLinkedRuleBuilder<? extends Rule>> providers = new LinkedList<AbstractBackToLinkedRuleBuilder<? extends Rule>>();
    private final Map<Key, Collection<AbstractBackToLinkedRuleBuilder<? extends Rule>>> providersIndex = new HashMap<Key, Collection<AbstractBackToLinkedRuleBuilder<? extends Rule>>>();

    FromBinderRuleSet() {
    }

    public <R extends Rule, RB extends AbstractBackToLinkedRuleBuilder<R>> void registerProvider(RB ruleBuilder) {
        this.providers.add(ruleBuilder);
        Key key = new Key(ruleBuilder.getPattern(), ruleBuilder.getNamespaceURI());
        Collection<AbstractBackToLinkedRuleBuilder<? extends Rule>> indexedProviders = this.providersIndex.get(key);
        if (indexedProviders == null) {
            indexedProviders = new ArrayList<AbstractBackToLinkedRuleBuilder<? extends Rule>>();
            this.providersIndex.put(key, indexedProviders);
        }
        indexedProviders.add(ruleBuilder);
    }

    public <R extends Rule, RB extends AbstractBackToLinkedRuleBuilder<R>> RB getProvider(String keyPattern, String namespaceURI, Class<RB> type) {
        Key key = new Key(keyPattern, namespaceURI);
        Collection<AbstractBackToLinkedRuleBuilder<? extends Rule>> indexedProviders = this.providersIndex.get(key);
        if (indexedProviders == null || indexedProviders.isEmpty()) {
            return null;
        }
        for (AbstractBackToLinkedRuleBuilder<? extends Rule> ruleProvider : indexedProviders) {
            if (!type.isInstance(ruleProvider)) continue;
            return (RB)((AbstractBackToLinkedRuleBuilder)type.cast(ruleProvider));
        }
        return null;
    }

    public void clear() {
        this.providers.clear();
        this.providersIndex.clear();
    }

    @Override
    public void addRuleInstances(Digester digester) {
        for (AbstractBackToLinkedRuleBuilder<? extends Rule> provider : this.providers) {
            digester.addRule(provider.getPattern(), provider.get());
        }
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    private static final class Key {
        private final String pattern;
        private final String namespaceURI;

        public Key(String pattern, String namespaceURI) {
            this.pattern = pattern;
            this.namespaceURI = namespaceURI;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode());
            result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.namespaceURI == null ? other.getNamespaceURI() != null : !this.namespaceURI.equals(other.getNamespaceURI())) {
                return false;
            }
            return !(this.pattern == null ? other.getPattern() != null : !this.pattern.equals(other.getPattern()));
        }

        public String toString() {
            return "Key [pattern=" + this.pattern + ", namespaceURI=" + this.namespaceURI + "]";
        }
    }
}

