/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.user;

import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.TokenValidator;
import com.icegreen.greenmail.user.UserException;
import jakarta.mail.internet.MimeMessage;
import java.util.Objects;

public class UserImpl
implements GreenMailUser {
    final String email;
    private final int cachedHashCode;
    private final String cachedHashCodeAsString;
    final String login;
    String password;
    private final ImapHostManager imapHostManager;
    private TokenValidator tokenValidator;

    public UserImpl(String email, String login, String password, ImapHostManager imapHostManager) {
        this.email = email;
        this.cachedHashCode = email.hashCode();
        this.cachedHashCodeAsString = String.valueOf(this.cachedHashCode);
        this.tokenValidator = null;
        this.login = login;
        this.password = password;
        this.imapHostManager = imapHostManager;
    }

    @Override
    public void create() {
        try {
            this.imapHostManager.createPrivateMailAccount(this);
        }
        catch (FolderException e) {
            throw new IllegalStateException("Can not create user" + this, e);
        }
    }

    @Override
    public void delete() {
        this.imapHostManager.deletePrivateMailAccount(this);
    }

    @Override
    public void deliver(MovingMessage msg) {
        try {
            this.imapHostManager.getInbox(this).store(msg);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not deliver " + msg + " for user " + this, e);
        }
    }

    @Override
    public void deliver(MimeMessage msg) {
        try {
            this.imapHostManager.getInbox(this).store(msg);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not deliver " + msg + " for user " + this, e);
        }
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getLogin() {
        if (null == this.login) {
            return this.email;
        }
        return this.login;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void authenticate(String pass) throws UserException {
        if (this.isTokenValidationAvailable()) {
            this.validateToken(pass);
            return;
        }
        this.validatePassword(pass);
    }

    private boolean isTokenValidationAvailable() {
        return this.tokenValidator != null;
    }

    private void validateToken(String pass) throws UserException {
        if (!this.tokenValidator.isValid(pass)) {
            throw new UserException("Invalid token");
        }
    }

    private void validatePassword(String pass) throws UserException {
        if (!Objects.equals(this.password, pass)) {
            throw new UserException("Invalid password");
        }
    }

    @Override
    public String getQualifiedMailboxName() {
        return this.cachedHashCodeAsString;
    }

    public void setTokenValidator(TokenValidator validator) {
        this.tokenValidator = validator;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserImpl)) {
            return false;
        }
        UserImpl that = (UserImpl)o;
        return this.email.equals(that.email);
    }

    public String toString() {
        return "UserImpl{email='" + this.email + '\'' + ", login='" + this.login + '\'' + '}';
    }
}

