/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.security;

import java.security.GeneralSecurityException;
import java.util.Map;
import javax.crypto.SecretKeyFactory;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.security.EncryptingPasswordEncoder;
import org.apache.kafka.security.PasswordEncoder;
import org.apache.kafka.server.util.Csv;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PasswordEncoderTest {
    PasswordEncoderTest() {
    }

    @Test
    public void testEncodeDecode() throws GeneralSecurityException {
        String defaultKeyFactoryAlgorithm;
        EncryptingPasswordEncoder encoder = PasswordEncoder.encrypting((Password)new Password("password-encoder-secret"), null, (String)"AES/CBC/PKCS5Padding", (int)128, (int)4096);
        String password = "test-password";
        String encoded = encoder.encode(new Password(password));
        Map encodedMap = Csv.parseCsvMap((String)encoded);
        Assertions.assertEquals((Object)"4096", encodedMap.get("iterations"));
        Assertions.assertEquals((Object)"128", encodedMap.get("keyLength"));
        try {
            SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            defaultKeyFactoryAlgorithm = "PBKDF2WithHmacSHA512";
        }
        catch (Exception e) {
            defaultKeyFactoryAlgorithm = "PBKDF2WithHmacSHA1";
        }
        Assertions.assertEquals((Object)defaultKeyFactoryAlgorithm, encodedMap.get("keyFactoryAlgorithm"));
        Assertions.assertEquals((Object)"AES/CBC/PKCS5Padding", encodedMap.get("cipherAlgorithm"));
        this.verifyEncodedPassword((PasswordEncoder)encoder, password, encoded);
    }

    @Test
    public void testEncoderConfigChange() throws GeneralSecurityException {
        EncryptingPasswordEncoder encoder = PasswordEncoder.encrypting((Password)new Password("password-encoder-secret"), (String)"PBKDF2WithHmacSHA1", (String)"DES/CBC/PKCS5Padding", (int)64, (int)1024);
        String password = "test-password";
        String encoded = encoder.encode(new Password(password));
        Map encodedMap = Csv.parseCsvMap((String)encoded);
        Assertions.assertEquals((Object)"1024", encodedMap.get("iterations"));
        Assertions.assertEquals((Object)"64", encodedMap.get("keyLength"));
        Assertions.assertEquals((Object)"PBKDF2WithHmacSHA1", encodedMap.get("keyFactoryAlgorithm"));
        Assertions.assertEquals((Object)"DES/CBC/PKCS5Padding", encodedMap.get("cipherAlgorithm"));
        EncryptingPasswordEncoder decoder = PasswordEncoder.encrypting((Password)new Password("password-encoder-secret"), (String)"PBKDF2WithHmacSHA1", (String)"AES/CBC/PKCS5Padding", (int)128, (int)2048);
        Assertions.assertEquals((Object)password, (Object)decoder.decode(encoded).value());
        EncryptingPasswordEncoder decoder2 = PasswordEncoder.encrypting((Password)new Password("secret-2"), (String)"PBKDF2WithHmacSHA1", (String)"AES/CBC/PKCS5Padding", (int)128, (int)1024);
        Assertions.assertThrows(ConfigException.class, () -> PasswordEncoderTest.lambda$testEncoderConfigChange$0((PasswordEncoder)decoder2, encoded));
    }

    @Test
    public void testEncodeDecodeAlgorithms() throws GeneralSecurityException {
        this.verifyEncodeDecode(null, "DES/CBC/PKCS5Padding", 64);
        this.verifyEncodeDecode(null, "DESede/CBC/PKCS5Padding", 192);
        this.verifyEncodeDecode(null, "AES/CBC/PKCS5Padding", 128);
        this.verifyEncodeDecode(null, "AES/CFB/PKCS5Padding", 128);
        this.verifyEncodeDecode(null, "AES/OFB/PKCS5Padding", 128);
        this.verifyEncodeDecode("PBKDF2WithHmacSHA1", "AES/CBC/PKCS5Padding", 128);
        this.verifyEncodeDecode(null, "AES/GCM/NoPadding", 128);
        this.verifyEncodeDecode("PBKDF2WithHmacSHA256", "AES/CBC/PKCS5Padding", 128);
        this.verifyEncodeDecode("PBKDF2WithHmacSHA512", "AES/CBC/PKCS5Padding", 128);
    }

    private void verifyEncodeDecode(String keyFactoryAlg, String cipherAlg, int keyLength) throws GeneralSecurityException {
        EncryptingPasswordEncoder encoder = PasswordEncoder.encrypting((Password)new Password("password-encoder-secret"), (String)keyFactoryAlg, (String)cipherAlg, (int)keyLength, (int)4096);
        String password = "test-password";
        String encoded = encoder.encode(new Password(password));
        this.verifyEncodedPassword((PasswordEncoder)encoder, password, encoded);
    }

    private void verifyEncodedPassword(PasswordEncoder encoder, String password, String encoded) throws GeneralSecurityException {
        Map encodedMap = Csv.parseCsvMap((String)encoded);
        Assertions.assertEquals((Object)String.valueOf(password.length()), encodedMap.get("passwordLength"));
        Assertions.assertNotNull((Object)PasswordEncoder.base64Decode((String)((String)encodedMap.get("salt"))), (String)"Invalid salt");
        Assertions.assertNotNull((Object)PasswordEncoder.base64Decode((String)((String)encodedMap.get("initializationVector"))), (String)"Invalid encoding parameters");
        Assertions.assertNotNull((Object)PasswordEncoder.base64Decode((String)((String)encodedMap.get("encryptedPassword"))), (String)"Invalid encoded password");
        Assertions.assertEquals((Object)password, (Object)encoder.decode(encoded).value());
    }

    private static /* synthetic */ void lambda$testEncoderConfigChange$0(PasswordEncoder decoder2, String encoded) throws Throwable {
        decoder2.decode(encoded);
    }
}

