/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util.timer;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.timer.TimerTask;
import org.apache.kafka.server.util.timer.TimerTaskEntry;
import org.apache.kafka.server.util.timer.TimerTaskList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimerTaskListTest {
    private static int size(TimerTaskList list) {
        AtomicInteger count = new AtomicInteger(0);
        list.foreach(__ -> count.incrementAndGet());
        return count.get();
    }

    @Test
    public void testAll() {
        AtomicInteger sharedCounter = new AtomicInteger(0);
        TimerTaskList list1 = new TimerTaskList(sharedCounter);
        TimerTaskList list2 = new TimerTaskList(sharedCounter);
        TimerTaskList list3 = new TimerTaskList(sharedCounter);
        List tasks = IntStream.rangeClosed(1, 10).mapToObj(i -> {
            TestTask task = new TestTask(0L);
            list1.add(new TimerTaskEntry((TimerTask)task, 10L));
            Assertions.assertEquals((int)i, (int)sharedCounter.get());
            return task;
        }).collect(Collectors.toList());
        Assertions.assertEquals((int)tasks.size(), (int)sharedCounter.get());
        tasks.stream().limit(4L).forEach(task -> {
            int prevCounter = sharedCounter.get();
            list2.add(new TimerTaskEntry(task, 10L));
            Assertions.assertEquals((int)prevCounter, (int)sharedCounter.get());
        });
        Assertions.assertEquals((int)6, (int)TimerTaskListTest.size(list1));
        Assertions.assertEquals((int)4, (int)TimerTaskListTest.size(list2));
        Assertions.assertEquals((int)tasks.size(), (int)sharedCounter.get());
        tasks.stream().skip(4L).forEach(task -> {
            int prevCounter = sharedCounter.get();
            list3.add(new TimerTaskEntry(task, 10L));
            Assertions.assertEquals((int)prevCounter, (int)sharedCounter.get());
        });
        Assertions.assertEquals((int)0, (int)TimerTaskListTest.size(list1));
        Assertions.assertEquals((int)4, (int)TimerTaskListTest.size(list2));
        Assertions.assertEquals((int)6, (int)TimerTaskListTest.size(list3));
        Assertions.assertEquals((int)tasks.size(), (int)sharedCounter.get());
        list1.foreach(TimerTask::cancel);
        Assertions.assertEquals((int)0, (int)TimerTaskListTest.size(list1));
        Assertions.assertEquals((int)4, (int)TimerTaskListTest.size(list2));
        Assertions.assertEquals((int)6, (int)TimerTaskListTest.size(list3));
        list2.foreach(TimerTask::cancel);
        Assertions.assertEquals((int)0, (int)TimerTaskListTest.size(list1));
        Assertions.assertEquals((int)0, (int)TimerTaskListTest.size(list2));
        Assertions.assertEquals((int)6, (int)TimerTaskListTest.size(list3));
        list3.foreach(TimerTask::cancel);
        Assertions.assertEquals((int)0, (int)TimerTaskListTest.size(list1));
        Assertions.assertEquals((int)0, (int)TimerTaskListTest.size(list2));
        Assertions.assertEquals((int)0, (int)TimerTaskListTest.size(list3));
    }

    @Test
    public void testGetDelay() {
        MockTime time = new MockTime();
        TimerTaskList list = new TimerTaskList(new AtomicInteger(0), (Time)time);
        list.setExpiration(time.hiResClockMs() + 10000L);
        time.sleep(5000L);
        Assertions.assertEquals((long)5L, (long)list.getDelay(TimeUnit.SECONDS));
    }

    private static class TestTask
    extends TimerTask {
        TestTask(long delayMs) {
            super(delayMs);
        }

        public void run() {
        }
    }
}

