/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.principal.PrincipalProvisioner;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.syncope.SyncopePrincipalProvisioner;
import org.apereo.cas.syncope.web.flow.SyncopeWebflowConfigurer;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.PrincipalProvisionerAction;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="SyncopeWebflowConfiguration", proxyBeanMethods=false)
class SyncopeWebflowConfiguration {
    SyncopeWebflowConfiguration() {
    }

    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Provisioning}, module="syncope")
    @Configuration(value="SyncopeProvisioningWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SyncopeProvisioningWebflowConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.syncope.provisioning.enabled").isTrue();

        SyncopeProvisioningWebflowConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalProvisioner principalProvisioner(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return (PrincipalProvisioner)BeanSupplier.of(PrincipalProvisioner.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new SyncopePrincipalProvisioner(casProperties.getAuthn().getSyncope().getProvisioning())).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"syncopePrincipalProvisionerAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action syncopePrincipalProvisionerAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="principalProvisioner") PrincipalProvisioner principalProvisioner) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new PrincipalProvisionerAction(principalProvisioner, casProperties.getScim())).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"syncopeCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer syncopeCasWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="syncopeWebflowConfigurer") CasWebflowConfigurer syncopeWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(syncopeWebflowConfigurer)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"syncopeWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer syncopeWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new SyncopeWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties)).otherwiseProxy().get();
        }
    }
}

