/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.apache.http.impl.client;

import com.signalfx.shaded.apache.http.HttpResponse;
import com.signalfx.shaded.apache.http.annotation.Contract;
import com.signalfx.shaded.apache.http.annotation.ThreadingBehavior;
import com.signalfx.shaded.apache.http.client.ServiceUnavailableRetryStrategy;
import com.signalfx.shaded.apache.http.protocol.HttpContext;
import com.signalfx.shaded.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final long retryInterval;

    public DefaultServiceUnavailableRetryStrategy(int maxRetries, int retryInterval) {
        Args.positive(maxRetries, "Max retries");
        Args.positive(retryInterval, "Retry interval");
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
    }

    public DefaultServiceUnavailableRetryStrategy() {
        this(1, 1000);
    }

    @Override
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return executionCount <= this.maxRetries && response.getStatusLine().getStatusCode() == 503;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }
}

