/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.ott;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ott.InMemoryOneTimeTokenService;
import org.springframework.security.authentication.ott.OneTimeTokenAuthenticationProvider;
import org.springframework.security.authentication.ott.OneTimeTokenService;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.ott.GenerateOneTimeTokenFilter;
import org.springframework.security.web.authentication.ott.OneTimeTokenAuthenticationConverter;
import org.springframework.security.web.authentication.ott.OneTimeTokenGenerationSuccessHandler;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.ui.DefaultOneTimeTokenSubmitPageGeneratingFilter;
import org.springframework.security.web.authentication.ui.DefaultResourcesFilter;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OneTimeTokenLoginConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<OneTimeTokenLoginConfigurer<H>, H> {
    private final ApplicationContext context;
    private OneTimeTokenService oneTimeTokenService;
    private AuthenticationConverter authenticationConverter = new OneTimeTokenAuthenticationConverter();
    private AuthenticationFailureHandler authenticationFailureHandler;
    private AuthenticationSuccessHandler authenticationSuccessHandler = new SavedRequestAwareAuthenticationSuccessHandler();
    private String defaultSubmitPageUrl = "/login/ott";
    private boolean submitPageEnabled = true;
    private String loginProcessingUrl = "/login/ott";
    private String tokenGeneratingUrl = "/ott/generate";
    private OneTimeTokenGenerationSuccessHandler oneTimeTokenGenerationSuccessHandler;
    private AuthenticationProvider authenticationProvider;

    public OneTimeTokenLoginConfigurer(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public void init(H http) {
        AuthenticationProvider authenticationProvider = this.getAuthenticationProvider(http);
        http.authenticationProvider(this.postProcess(authenticationProvider));
        this.configureDefaultLoginPage(http);
    }

    private void configureDefaultLoginPage(H http) {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter == null) {
            return;
        }
        loginPageGeneratingFilter.setOneTimeTokenEnabled(true);
        loginPageGeneratingFilter.setOneTimeTokenGenerationUrl(this.tokenGeneratingUrl);
        if (this.authenticationFailureHandler == null && StringUtils.hasText((String)loginPageGeneratingFilter.getLoginPageUrl())) {
            this.authenticationFailureHandler = new SimpleUrlAuthenticationFailureHandler(loginPageGeneratingFilter.getLoginPageUrl() + "?error");
        }
    }

    @Override
    public void configure(H http) {
        this.configureSubmitPage(http);
        this.configureOttGenerateFilter(http);
        this.configureOttAuthenticationFilter(http);
    }

    private void configureOttAuthenticationFilter(H http) {
        AuthenticationManager authenticationManager = http.getSharedObject(AuthenticationManager.class);
        AuthenticationFilter oneTimeTokenAuthenticationFilter = new AuthenticationFilter(authenticationManager, this.authenticationConverter);
        oneTimeTokenAuthenticationFilter.setSecurityContextRepository(this.getSecurityContextRepository(http));
        oneTimeTokenAuthenticationFilter.setRequestMatcher((RequestMatcher)AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)this.loginProcessingUrl));
        oneTimeTokenAuthenticationFilter.setFailureHandler(this.getAuthenticationFailureHandler());
        oneTimeTokenAuthenticationFilter.setSuccessHandler(this.authenticationSuccessHandler);
        http.addFilter((Filter)this.postProcess(oneTimeTokenAuthenticationFilter));
    }

    private SecurityContextRepository getSecurityContextRepository(H http) {
        SecurityContextRepository securityContextRepository = http.getSharedObject(SecurityContextRepository.class);
        if (securityContextRepository != null) {
            return securityContextRepository;
        }
        return new HttpSessionSecurityContextRepository();
    }

    private void configureOttGenerateFilter(H http) {
        GenerateOneTimeTokenFilter generateFilter = new GenerateOneTimeTokenFilter(this.getOneTimeTokenService(http), this.getOneTimeTokenGenerationSuccessHandler(http));
        generateFilter.setRequestMatcher((RequestMatcher)AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)this.tokenGeneratingUrl));
        http.addFilter((Filter)this.postProcess(generateFilter));
        http.addFilter((Filter)DefaultResourcesFilter.css());
    }

    private OneTimeTokenGenerationSuccessHandler getOneTimeTokenGenerationSuccessHandler(H http) {
        if (this.oneTimeTokenGenerationSuccessHandler == null) {
            this.oneTimeTokenGenerationSuccessHandler = this.getBeanOrNull(http, OneTimeTokenGenerationSuccessHandler.class);
        }
        if (this.oneTimeTokenGenerationSuccessHandler == null) {
            throw new IllegalStateException("A OneTimeTokenGenerationSuccessHandler is required to enable oneTimeTokenLogin().\nPlease provide it as a bean or pass it to the oneTimeTokenLogin() DSL.\n");
        }
        return this.oneTimeTokenGenerationSuccessHandler;
    }

    private void configureSubmitPage(H http) {
        if (!this.submitPageEnabled) {
            return;
        }
        DefaultOneTimeTokenSubmitPageGeneratingFilter submitPage = new DefaultOneTimeTokenSubmitPageGeneratingFilter();
        submitPage.setResolveHiddenInputs(this::hiddenInputs);
        submitPage.setRequestMatcher((RequestMatcher)AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)this.defaultSubmitPageUrl));
        submitPage.setLoginProcessingUrl(this.loginProcessingUrl);
        http.addFilter((Filter)this.postProcess(submitPage));
    }

    private AuthenticationProvider getAuthenticationProvider(H http) {
        if (this.authenticationProvider != null) {
            return this.authenticationProvider;
        }
        UserDetailsService userDetailsService = (UserDetailsService)this.getContext().getBean(UserDetailsService.class);
        this.authenticationProvider = new OneTimeTokenAuthenticationProvider(this.getOneTimeTokenService(http), userDetailsService);
        return this.authenticationProvider;
    }

    public OneTimeTokenLoginConfigurer<H> authenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"authenticationProvider cannot be null");
        this.authenticationProvider = authenticationProvider;
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> tokenGeneratingUrl(String tokenGeneratingUrl) {
        Assert.hasText((String)tokenGeneratingUrl, (String)"tokenGeneratingUrl cannot be null or empty");
        this.tokenGeneratingUrl = tokenGeneratingUrl;
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> tokenGenerationSuccessHandler(OneTimeTokenGenerationSuccessHandler oneTimeTokenGenerationSuccessHandler) {
        Assert.notNull((Object)oneTimeTokenGenerationSuccessHandler, (String)"oneTimeTokenGenerationSuccessHandler cannot be null");
        this.oneTimeTokenGenerationSuccessHandler = oneTimeTokenGenerationSuccessHandler;
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> loginProcessingUrl(String loginProcessingUrl) {
        Assert.hasText((String)loginProcessingUrl, (String)"loginProcessingUrl cannot be null or empty");
        this.loginProcessingUrl = loginProcessingUrl;
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> showDefaultSubmitPage(boolean show) {
        this.submitPageEnabled = show;
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> defaultSubmitPageUrl(String submitPageUrl) {
        Assert.hasText((String)submitPageUrl, (String)"submitPageUrl cannot be null or empty");
        this.defaultSubmitPageUrl = submitPageUrl;
        this.showDefaultSubmitPage(true);
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> tokenService(OneTimeTokenService oneTimeTokenService) {
        Assert.notNull((Object)oneTimeTokenService, (String)"oneTimeTokenService cannot be null");
        this.oneTimeTokenService = oneTimeTokenService;
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> authenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> authenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        this.authenticationFailureHandler = authenticationFailureHandler;
        return this;
    }

    public OneTimeTokenLoginConfigurer<H> authenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
        this.authenticationSuccessHandler = authenticationSuccessHandler;
        return this;
    }

    private AuthenticationFailureHandler getAuthenticationFailureHandler() {
        if (this.authenticationFailureHandler != null) {
            return this.authenticationFailureHandler;
        }
        this.authenticationFailureHandler = new SimpleUrlAuthenticationFailureHandler("/login?error");
        return this.authenticationFailureHandler;
    }

    private OneTimeTokenService getOneTimeTokenService(H http) {
        if (this.oneTimeTokenService != null) {
            return this.oneTimeTokenService;
        }
        OneTimeTokenService bean = this.getBeanOrNull(http, OneTimeTokenService.class);
        this.oneTimeTokenService = bean != null ? bean : new InMemoryOneTimeTokenService();
        return this.oneTimeTokenService;
    }

    private <C> C getBeanOrNull(H http, Class<C> clazz) {
        ApplicationContext context = http.getSharedObject(ApplicationContext.class);
        if (context == null) {
            return null;
        }
        return (C)context.getBeanProvider(clazz).getIfUnique();
    }

    private Map<String, String> hiddenInputs(HttpServletRequest request) {
        CsrfToken token = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
        return token != null ? Collections.singletonMap(token.getParameterName(), token.getToken()) : Collections.emptyMap();
    }

    public ApplicationContext getContext() {
        return this.context;
    }
}

