/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldup;

import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;

public class LdUpConfiguration
extends AbstractConfiguration {
    private static final String DEFAULT_ID_ATTRIBUTE = "entryUUID";
    private String url;
    private boolean useStartTLS = false;
    private boolean autoReconnect = true;
    private int connectTimeoutSeconds = 30;
    private int responseTimeoutSeconds = 30;
    private String bindDn;
    private GuardedString bindPassword;
    private int poolMinSize = 1;
    private int poolMaxSize = 10;
    private String baseDn;
    private String accountObjectClass = "inetOrgPerson";
    private String groupObjectClass = "groupOfUniqueNames";
    private String uidAttribute = "entryUUID";
    private String gidAttribute = "entryUUID";
    private String aidAttribute = "entryUUID";
    private String passwordAttribute = "userPassword";
    private String groupMemberAttribute = "uniqueMember";
    private boolean legacyCompatibilityMode = false;

    @ConfigurationProperty(displayMessageKey="url.display", helpMessageKey="url.help", required=true, order=1)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @ConfigurationProperty(displayMessageKey="useStartTLS.display", helpMessageKey="urluseStartTLS.help", order=2)
    public boolean isUseStartTLS() {
        return this.useStartTLS;
    }

    public void setUseStartTLS(boolean useStartTLS) {
        this.useStartTLS = useStartTLS;
    }

    @ConfigurationProperty(displayMessageKey="autoReconnect.display", helpMessageKey="autoReconnect.help", order=3)
    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    @ConfigurationProperty(displayMessageKey="connectTimeoutSeconds.display", helpMessageKey="connectTimeoutSeconds.help", required=true, order=4)
    public int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    @ConfigurationProperty(displayMessageKey="responseTimeoutSeconds.display", helpMessageKey="responseTimeoutSeconds.help", required=true, order=5)
    public int getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    public void setResponseTimeoutSeconds(int responseTimeoutSeconds) {
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    @ConfigurationProperty(displayMessageKey="bindDn.display", helpMessageKey="bindDn.help", order=6)
    public String getBindDn() {
        return this.bindDn;
    }

    public void setBindDn(String bindDn) {
        this.bindDn = bindDn;
    }

    @ConfigurationProperty(displayMessageKey="bindPassword.display", helpMessageKey="bindPassword.help", confidential=true, order=7)
    public GuardedString getBindPassword() {
        return this.bindPassword;
    }

    public void setBindPassword(GuardedString bindPassword) {
        this.bindPassword = bindPassword;
    }

    @ConfigurationProperty(displayMessageKey="poolMinSize.display", helpMessageKey="poolMinSize.help", order=8)
    public int getPoolMinSize() {
        return this.poolMinSize;
    }

    public void setPoolMinSize(int poolMinSize) {
        this.poolMinSize = poolMinSize;
    }

    @ConfigurationProperty(displayMessageKey="poolMaxSize.display", helpMessageKey="poolMaxSize.help", order=9)
    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
    }

    @ConfigurationProperty(displayMessageKey="baseDn.display", helpMessageKey="baseDn.help", order=10)
    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    @ConfigurationProperty(displayMessageKey="accountObjectClass.display", helpMessageKey="accountObjectClass.help", required=true, order=11)
    public String getAccountObjectClass() {
        return this.accountObjectClass;
    }

    public void setAccountObjectClass(String accountObjectClass) {
        this.accountObjectClass = accountObjectClass;
    }

    @ConfigurationProperty(displayMessageKey="groupObjectClass.display", helpMessageKey="groupObjectClass.help", required=true, order=12)
    public String getGroupObjectClass() {
        return this.groupObjectClass;
    }

    public void setGroupObjectClass(String groupObjectClass) {
        this.groupObjectClass = groupObjectClass;
    }

    @ConfigurationProperty(displayMessageKey="uidAttribute.display", helpMessageKey="uidAttribute.help", required=true, order=13)
    public String getUidAttribute() {
        return this.uidAttribute;
    }

    public void setUidAttribute(String uidAttribute) {
        this.uidAttribute = uidAttribute;
    }

    @ConfigurationProperty(displayMessageKey="gidAttribute.display", helpMessageKey="gidAttribute.help", required=true, order=14)
    public String getGidAttribute() {
        return this.gidAttribute;
    }

    public void setGidAttribute(String gidAttribute) {
        this.gidAttribute = gidAttribute;
    }

    @ConfigurationProperty(displayMessageKey="aidAttribute.display", helpMessageKey="aidAttribute.help", required=true, order=15)
    public String getAidAttribute() {
        return this.aidAttribute;
    }

    public void setAidAttribute(String aidAttribute) {
        this.aidAttribute = aidAttribute;
    }

    @ConfigurationProperty(displayMessageKey="passwordAttribute.display", helpMessageKey="passwordAttribute.help", required=true, order=16)
    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    @ConfigurationProperty(displayMessageKey="groupMemberAttribute.display", helpMessageKey="groupMemberAttribute.help", required=true, order=17)
    public String getGroupMemberAttribute() {
        return this.groupMemberAttribute;
    }

    public void setGroupMemberAttribute(String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
    }

    @ConfigurationProperty(displayMessageKey="legacyCompatibilityMode.display", helpMessageKey="legacyCompatibilityMode.help", order=18)
    public boolean isLegacyCompatibilityMode() {
        return this.legacyCompatibilityMode;
    }

    public void setLegacyCompatibilityMode(boolean legacyCompatibilityMode) {
        this.legacyCompatibilityMode = legacyCompatibilityMode;
    }

    public void validate() {
        if (StringUtil.isBlank((String)this.url)) {
            throw new ConfigurationException("Missing LDAP URL");
        }
        if (this.connectTimeoutSeconds < 0) {
            throw new ConfigurationException("Negative connectTimeoutSeconds");
        }
        if (this.responseTimeoutSeconds < 0) {
            throw new ConfigurationException("Negative responseTimeoutSeconds");
        }
        if (StringUtil.isBlank((String)this.bindDn) && this.bindPassword != null || StringUtil.isNotBlank((String)this.bindDn) && this.bindPassword == null) {
            throw new ConfigurationException("Bind DN and password must be both either null or non-null");
        }
        if (StringUtil.isBlank((String)this.baseDn)) {
            throw new ConfigurationException("Missing base DN");
        }
    }
}

