/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.GroupCoordinatorBaseRequestTest;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(types={Type.KRAFT})
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\u0004\t\u00015A\u0001B\u0005\u0001\u0003\u0002\u0003\u0006Ia\u0005\u0005\u00063\u0001!\tA\u0007\u0005\u0006;\u0001!\tA\b\u0005\u0006\u0011\u0002!\tA\b\u0005\u0006\u0017\u0002!\tA\b\u0005\u0006=\u0002!Ia\u0018\u0002\u0018\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e*fcV,7\u000f\u001e+fgRT!!\u0003\u0006\u0002\rM,'O^3s\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003!I!!\u0005\u0005\u0003?\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014()Y:f%\u0016\fX/Z:u)\u0016\u001cH/A\u0004dYV\u001cH/\u001a:\u0011\u0005Q9R\"A\u000b\u000b\u0005YQ\u0011\u0001\u0002;fgRL!\u0001G\u000b\u0003\u001f\rcWo\u001d;fe&s7\u000f^1oG\u0016\fa\u0001P5oSRtDCA\u000e\u001d!\ty\u0001\u0001C\u0003\u0013\u0005\u0001\u00071#\u0001\"uKN$xJ\u001a4tKR\u001cu.\\7ji^KG\u000f\u001b(fo\u000e{gn];nKJ<%o\\;q!J|Go\\2pY\u0006sGMT3x\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J$\u0012a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0005+:LG\u000f\u000b\u0003\u0004M1j\u0003CA\u0014+\u001b\u0005A#BA\u0015\u0016\u0003)\tgN\\8uCRLwN\\\u0005\u0003W!\u00121b\u00117vgR,'\u000fV3ti\u0006\u00012/\u001a:wKJ\u0004&o\u001c9feRLWm\u001d\u0017\u0006]aj\u0004)R\u0016\u0006_I\u001aTG\u000e\t\u0003OAJ!!\r\u0015\u0003+\rcWo\u001d;fe\u000e{gNZ5h!J|\u0007/\u001a:us\u0006\u00191.Z=\"\u0003Q\nQe\u001a:pkBt3m\\8sI&t\u0017\r^8s]I,'-\u00197b]\u000e,g\u0006\u001d:pi>\u001cw\u000e\\:\u0002\u000bY\fG.^3\"\u0003]\n\u0001c\u00197bgNL7\rL2p]N,X.\u001a:,\u000b=\u0012\u0014(N\u001e\"\u0003i\nQe\u001a:pkBt3m\u001c8tk6,'OL7bq:\u001aXm]:j_:tC/[7f_V$h&\\:\"\u0003q\naA\u000e\u00191aA\u00024&B\u00183}UZ\u0014%A \u0002C\u001d\u0014x.\u001e9/G>t7/^7fe:\u001aXm]:j_:tC/[7f_V$h&\\:,\u000b=\u0012\u0014)N\"\"\u0003\t\u000bAd\u001c4gg\u0016$8O\f;pa&\u001cgF\\;n]A\f'\u000f^5uS>t7/I\u0001E\u0003\u0005\t4&B\u00183\rV\u001a\u0015%A$\u0002A=4gm]3ug:\"x\u000e]5d]I,\u0007\u000f\\5dCRLwN\u001c\u0018gC\u000e$xN]\u0001Ci\u0016\u001cHo\u00144gg\u0016$8i\\7nSR<\u0016\u000e\u001e5PY\u0012\u001cuN\\:v[\u0016\u0014xI]8vaB\u0013x\u000e^8d_2\fe\u000e\u001a(fo\u001e\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\b\u0006\u0002\u0003'Y)c3A\f!F\u0003\t#Xm\u001d;PM\u001a\u001cX\r^\"p[6LGoV5uQ>cGmQ8ogVlWM]$s_V\u0004\bK]8u_\u000e|G.\u00118e\u001f2$wI]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0007\u000b\u0019je\n\f.\u0002\u000bQL\b/Z:-\u0007=#v\u000bJ\u0001Q\u0013\t\t&+\u0001\u0002[\u0017*\u00111\u000bK\u0001\u0005)f\u0004X\rJ\u0001V\u0013\t1&+A\u0003L%\u00063E\u000bJ\u0001Y\u0013\tI&+\u0001\u0005D\u001f~[%+\u0011$UY\rY\u0006)R\u0016\u0006_I\u001aT\u0007X\u0011\u0002;\u000691\r\\1tg&\u001c\u0017\u0001\u0005;fgR|eMZ:fi\u000e{W.\\5u)\ty\u0002\rC\u0003b\r\u0001\u0007!-\u0001\bvg\u0016tUm\u001e)s_R|7m\u001c7\u0011\u0005\u0001\u001a\u0017B\u00013\"\u0005\u001d\u0011un\u001c7fC:DC\u0001\u000146eB\u0011q\r]\u0007\u0002Q*\u0011\u0011N[\u0001\u0004CBL'BA6m\u0003\u001dQW\u000f]5uKJT!!\u001c8\u0002\u000b),h.\u001b;\u000b\u0003=\f1a\u001c:h\u0013\t\t\bNA\u0004US6,w.\u001e;\u001f\u0003aDC\u0001\u0001;6uB\u0011Q\u000f_\u0007\u0002m*\u0011q\u000f[\u0001\nKb$XM\\:j_:L!!\u001f<\u0003\u0015\u0015CH/\u001a8e/&$\b\u000eL\u0001|G\u0005a\bCA?\u0000\u001b\u0005q(BA7\u0016\u0013\r\t\tA \u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8tQ\u0019\u0001\u0011QA'\u0002\fA\u0019q%a\u0002\n\u0007\u0005%\u0001FA\nDYV\u001cH/\u001a:UKN$H)\u001a4bk2$8\u000fL\u0001UQ\u0019\u0001\u0011qB\u001b\u0002\u0016A\u0019q-!\u0005\n\u0007\u0005M\u0001NA\u0002UC\u001e\f#!a\u0006\u0002\u0017%tG/Z4sCRLwN\u001c")
public class OffsetCommitRequestTest
extends GroupCoordinatorBaseRequestTest {
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer"), @ClusterConfigProperty(key="group.consumer.max.session.timeout.ms", value="600000"), @ClusterConfigProperty(key="group.consumer.session.timeout.ms", value="600000"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testOffsetCommitWithNewConsumerGroupProtocolAndNewGroupCoordinator() {
        this.testOffsetCommit(true);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testOffsetCommitWithOldConsumerGroupProtocolAndNewGroupCoordinator() {
        this.testOffsetCommit(false);
    }

    @ClusterTest(types={Type.ZK, Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testOffsetCommitWithOldConsumerGroupProtocolAndOldGroupCoordinator() {
        this.testOffsetCommit(false);
    }

    /*
     * WARNING - void declaration
     */
    private void testOffsetCommit(boolean useNewProtocol) {
        void var3_3;
        if (useNewProtocol && !this.isNewGroupCoordinatorEnabled()) {
            Assertions.fail((String)"Cannot use the new protocol with the old group coordinator.");
        }
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        Tuple2<String, Object> tuple2 = this.joinConsumerGroup("grp", useNewProtocol);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String memberId = (String)tuple2._1();
        int n = tuple2._2$mcI$sp();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), (int)ApiKeys.OFFSET_COMMIT.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> OffsetCommitRequestTest.$anonfun$testOffsetCommit$1(this, (String)var3_3, n, useNewProtocol, arg_0)));
    }

    public static final /* synthetic */ void $anonfun$testOffsetCommit$1(OffsetCommitRequestTest $this, String memberId$1, int memberEpoch$1, boolean useNewProtocol$1, int version) {
        $this.commitOffset("grp", memberId$1, memberEpoch$1, "foo", 0, 100L, useNewProtocol$1 && version < 9 ? Errors.UNSUPPORTED_VERSION : Errors.NONE, (short)version);
        $this.commitOffset("unknown", memberId$1, memberEpoch$1, "foo", 0, 100L, $this.isNewGroupCoordinatorEnabled() && version >= 9 ? Errors.GROUP_ID_NOT_FOUND : Errors.ILLEGAL_GENERATION, (short)version);
        $this.commitOffset("", memberId$1, memberEpoch$1, "foo", 0, 100L, $this.isNewGroupCoordinatorEnabled() && version >= 9 ? Errors.GROUP_ID_NOT_FOUND : Errors.ILLEGAL_GENERATION, (short)version);
        $this.commitOffset("grp", "", memberEpoch$1, "foo", 0, 100L, Errors.UNKNOWN_MEMBER_ID, (short)version);
        $this.commitOffset("grp", memberId$1, memberEpoch$1 + 1, "foo", 0, 100L, useNewProtocol$1 && version >= 9 ? Errors.STALE_MEMBER_EPOCH : (useNewProtocol$1 ? Errors.UNSUPPORTED_VERSION : Errors.ILLEGAL_GENERATION), (short)version);
        $this.commitOffset("other-grp", "", -1, "foo", 0, 100L, Errors.NONE, (short)version);
    }

    public OffsetCommitRequestTest(ClusterInstance cluster) {
        super(cluster);
    }
}

