/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.metadata;

import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.metadata.BaseAuthenticationMetaDataPopulator;
import org.apereo.cas.configuration.model.support.mfa.BaseMultifactorAuthenticationProviderProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.function.FunctionUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.util.StringUtils;

public class MultifactorAuthenticationProviderMetadataPopulator
extends BaseAuthenticationMetaDataPopulator {
    private final String authenticationContextAttribute;
    private final ObjectProvider<? extends MultifactorAuthenticationProvider> provider;
    private final ServicesManager servicesManager;

    public void populateAttributes(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        RegisteredService registeredService = this.servicesManager.findServiceBy(transaction.getService());
        MultifactorAuthenticationFailureModeEvaluator failureEval = ((MultifactorAuthenticationProvider)this.provider.getObject()).getFailureModeEvaluator();
        boolean bypass = failureEval != null && failureEval.evaluate(registeredService, (MultifactorAuthenticationProvider)this.provider.getObject()) == BaseMultifactorAuthenticationProviderProperties.MultifactorAuthenticationProviderFailureModes.PHANTOM && !((MultifactorAuthenticationProvider)this.provider.getObject()).isAvailable(registeredService);
        FunctionUtils.doIf((boolean)bypass, __ -> StringUtils.commaDelimitedListToSet((String)this.authenticationContextAttribute).forEach(attribute -> builder.mergeAttribute(attribute, (Object)((MultifactorAuthenticationProvider)this.provider.getObject()).getId()))).accept(this.provider);
    }

    public boolean supports(Credential credential) {
        return ((MultifactorAuthenticationProvider)this.provider.getObject()).getFailureModeEvaluator() != null && credential != null;
    }

    @Override
    @Generated
    public String toString() {
        return "MultifactorAuthenticationProviderMetadataPopulator(super=" + super.toString() + ", authenticationContextAttribute=" + this.authenticationContextAttribute + ", provider=" + String.valueOf(this.provider) + ", servicesManager=" + String.valueOf(this.servicesManager) + ")";
    }

    @Generated
    public MultifactorAuthenticationProviderMetadataPopulator(String authenticationContextAttribute, ObjectProvider<? extends MultifactorAuthenticationProvider> provider, ServicesManager servicesManager) {
        this.authenticationContextAttribute = authenticationContextAttribute;
        this.provider = provider;
        this.servicesManager = servicesManager;
    }
}

