/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.policy;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationPolicyExecutionResult;
import org.apereo.cas.authentication.exceptions.UniquePrincipalRequiredException;
import org.apereo.cas.authentication.policy.BaseAuthenticationPolicy;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.core.authentication.policy.UniquePrincipalAuthenticationPolicyProperties;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ConfigurableApplicationContext;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class UniquePrincipalAuthenticationPolicy
extends BaseAuthenticationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UniquePrincipalAuthenticationPolicy.class);
    private static final long serialVersionUID = 3974114391376732470L;
    private final TicketRegistry ticketRegistry;
    private final ObjectProvider<SingleSignOnParticipationStrategy> singleSignOnParticipationStrategy;
    private final UniquePrincipalAuthenticationPolicyProperties properties;

    public AuthenticationPolicyExecutionResult isSatisfiedBy(Authentication authentication, Set<AuthenticationHandler> authenticationHandlers, ConfigurableApplicationContext applicationContext, Map<String, ? extends Serializable> context) throws Throwable {
        Principal authPrincipal;
        long count;
        boolean ssoParticipation;
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().httpServletRequest(request).build();
        SingleSignOnParticipationStrategy strategy = (SingleSignOnParticipationStrategy)this.singleSignOnParticipationStrategy.getObject();
        boolean bl = ssoParticipation = strategy.supports(ssoRequest) && strategy.isParticipating(ssoRequest);
        if (!context.containsKey(Assertion.class.getName()) && ssoParticipation && (count = this.ticketRegistry.countSessionsFor((authPrincipal = authentication.getPrincipal()).getId())) > (long)this.properties.getMaximumAllowedSessions()) {
            LOGGER.warn("[{}] cannot be satisfied for [{}]; [{}] sessions currently exist", new Object[]{this.getName(), authPrincipal.getId(), count});
            throw new UniquePrincipalRequiredException();
        }
        return AuthenticationPolicyExecutionResult.success();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniquePrincipalAuthenticationPolicy)) {
            return false;
        }
        UniquePrincipalAuthenticationPolicy other = (UniquePrincipalAuthenticationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TicketRegistry this$ticketRegistry = this.ticketRegistry;
        TicketRegistry other$ticketRegistry = other.ticketRegistry;
        if (this$ticketRegistry == null ? other$ticketRegistry != null : !this$ticketRegistry.equals(other$ticketRegistry)) {
            return false;
        }
        ObjectProvider<SingleSignOnParticipationStrategy> this$singleSignOnParticipationStrategy = this.singleSignOnParticipationStrategy;
        ObjectProvider<SingleSignOnParticipationStrategy> other$singleSignOnParticipationStrategy = other.singleSignOnParticipationStrategy;
        if (this$singleSignOnParticipationStrategy == null ? other$singleSignOnParticipationStrategy != null : !this$singleSignOnParticipationStrategy.equals(other$singleSignOnParticipationStrategy)) {
            return false;
        }
        UniquePrincipalAuthenticationPolicyProperties this$properties = this.properties;
        UniquePrincipalAuthenticationPolicyProperties other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UniquePrincipalAuthenticationPolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TicketRegistry $ticketRegistry = this.ticketRegistry;
        result = result * 59 + ($ticketRegistry == null ? 43 : $ticketRegistry.hashCode());
        ObjectProvider<SingleSignOnParticipationStrategy> $singleSignOnParticipationStrategy = this.singleSignOnParticipationStrategy;
        result = result * 59 + ($singleSignOnParticipationStrategy == null ? 43 : $singleSignOnParticipationStrategy.hashCode());
        UniquePrincipalAuthenticationPolicyProperties $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    @Generated
    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    @Generated
    public ObjectProvider<SingleSignOnParticipationStrategy> getSingleSignOnParticipationStrategy() {
        return this.singleSignOnParticipationStrategy;
    }

    @Generated
    public UniquePrincipalAuthenticationPolicyProperties getProperties() {
        return this.properties;
    }

    @Generated
    public UniquePrincipalAuthenticationPolicy(TicketRegistry ticketRegistry, ObjectProvider<SingleSignOnParticipationStrategy> singleSignOnParticipationStrategy, UniquePrincipalAuthenticationPolicyProperties properties) {
        this.ticketRegistry = ticketRegistry;
        this.singleSignOnParticipationStrategy = singleSignOnParticipationStrategy;
        this.properties = properties;
    }
}

