/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.identityconnectors.framework.common.objects.filter.AndFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsAllValuesFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.ExternallyChainedFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.NotFilter;
import org.identityconnectors.framework.common.objects.filter.OrFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public abstract class AbstractFilterTranslator<T>
implements FilterTranslator<T> {
    @Override
    public final List<T> translate(Filter filter) {
        if (filter == null) {
            return new ArrayList();
        }
        filter = this.eliminateExternallyChainedFilters(filter);
        filter = this.normalizeNot(filter);
        if ((filter = this.simplifyAndDistribute(filter)) == null) {
            return new ArrayList();
        }
        List<T> result = this.translateInternal(filter);
        HashSet<T> set = new HashSet<T>();
        ArrayList<T> optimized = new ArrayList<T>(result.size());
        for (T obj : result) {
            if (!set.add(obj)) continue;
            optimized.add(obj);
        }
        return optimized;
    }

    private Filter eliminateExternallyChainedFilters(Filter filter) {
        while (filter instanceof ExternallyChainedFilter) {
            filter = ((ExternallyChainedFilter)filter).getFilter();
        }
        return filter;
    }

    private Filter normalizeNot(Filter filter) {
        if (filter instanceof AndFilter) {
            AndFilter af = (AndFilter)filter;
            return new AndFilter(this.normalizeNot(af.getLeft()), this.normalizeNot(af.getRight()));
        }
        if (filter instanceof OrFilter) {
            OrFilter of = (OrFilter)filter;
            return new OrFilter(this.normalizeNot(of.getLeft()), this.normalizeNot(of.getRight()));
        }
        if (filter instanceof NotFilter) {
            NotFilter nf = (NotFilter)filter;
            return this.negate(this.normalizeNot(nf.getFilter()));
        }
        return filter;
    }

    private Filter negate(Filter filter) {
        if (filter instanceof AndFilter) {
            AndFilter af = (AndFilter)filter;
            return new OrFilter(this.negate(af.getLeft()), this.negate(af.getRight()));
        }
        if (filter instanceof OrFilter) {
            OrFilter of = (OrFilter)filter;
            return new AndFilter(this.negate(of.getLeft()), this.negate(of.getRight()));
        }
        if (filter instanceof NotFilter) {
            NotFilter nf = (NotFilter)filter;
            return nf.getFilter();
        }
        return new NotFilter(filter);
    }

    private Filter simplifyAndDistribute(Filter filter) {
        if (filter instanceof AndFilter) {
            OrFilter newFilter;
            AndFilter af = (AndFilter)filter;
            Filter simplifiedLeft = this.simplifyAndDistribute(af.getLeft());
            Filter simplifiedRight = this.simplifyAndDistribute(af.getRight());
            if (simplifiedLeft == null) {
                return simplifiedRight;
            }
            if (simplifiedRight == null) {
                return simplifiedLeft;
            }
            List<T> leftExprs = this.translateInternal(simplifiedLeft);
            List<T> rightExprs = this.translateInternal(simplifiedRight);
            if (leftExprs.isEmpty()) {
                throw new IllegalStateException("Translation method is inconsistent: " + String.valueOf(leftExprs));
            }
            if (rightExprs.isEmpty()) {
                throw new IllegalStateException("Translation method is inconsistent: " + String.valueOf(rightExprs));
            }
            boolean anyAndsPossible = false;
            for (T leftExpr : leftExprs) {
                for (T rightExpr : rightExprs) {
                    T test = this.createAndExpression(leftExpr, rightExpr);
                    if (test == null) continue;
                    anyAndsPossible = true;
                    break;
                }
                if (!anyAndsPossible) continue;
                break;
            }
            if (!anyAndsPossible) {
                if (leftExprs.size() <= rightExprs.size()) {
                    return simplifiedLeft;
                }
                return simplifiedRight;
            }
            if (leftExprs.size() > 1) {
                OrFilter left = (OrFilter)simplifiedLeft;
                newFilter = new OrFilter(new AndFilter(left.getLeft(), simplifiedRight), new AndFilter(left.getRight(), simplifiedRight));
                return this.simplifyAndDistribute(newFilter);
            }
            if (rightExprs.size() > 1) {
                OrFilter right = (OrFilter)simplifiedRight;
                newFilter = new OrFilter(new AndFilter(simplifiedLeft, right.getLeft()), new AndFilter(simplifiedLeft, right.getRight()));
                return this.simplifyAndDistribute(newFilter);
            }
            assert (anyAndsPossible);
            return new AndFilter(simplifiedLeft, simplifiedRight);
        }
        if (filter instanceof OrFilter) {
            OrFilter of = (OrFilter)filter;
            Filter simplifiedLeft = this.simplifyAndDistribute(of.getLeft());
            Filter simplifiedRight = this.simplifyAndDistribute(of.getRight());
            if (simplifiedLeft == null || simplifiedRight == null) {
                return null;
            }
            return new OrFilter(simplifiedLeft, simplifiedRight);
        }
        T expr = this.createLeafExpression(filter);
        if (expr == null) {
            return null;
        }
        return filter;
    }

    private List<T> translateInternal(Filter filter) {
        if (filter instanceof AndFilter) {
            T result = this.translateAnd((AndFilter)filter);
            ArrayList<T> rv = new ArrayList<T>();
            if (result != null) {
                rv.add(result);
            }
            return rv;
        }
        if (filter instanceof OrFilter) {
            return this.translateOr((OrFilter)filter);
        }
        T expr = this.createLeafExpression(filter);
        ArrayList<T> exprs = new ArrayList<T>();
        if (expr != null) {
            exprs.add(expr);
        }
        return exprs;
    }

    private T translateAnd(AndFilter filter) {
        List<T> leftExprs = this.translateInternal(filter.getLeft());
        List<T> rightExprs = this.translateInternal(filter.getRight());
        if (leftExprs.size() != 1) {
            throw new IllegalStateException("Translation method is inconsistent: " + String.valueOf(leftExprs));
        }
        if (rightExprs.size() != 1) {
            throw new IllegalStateException("Translation method is inconsistent: " + String.valueOf(rightExprs));
        }
        T rv = this.createAndExpression(leftExprs.get(0), rightExprs.get(0));
        if (rv == null) {
            throw new IllegalStateException("createAndExpression is inconsistent");
        }
        return rv;
    }

    private List<T> translateOr(OrFilter filter) {
        T val;
        List<T> leftExprs = this.translateInternal(filter.getLeft());
        List<T> rightExprs = this.translateInternal(filter.getRight());
        if (leftExprs.isEmpty()) {
            throw new IllegalStateException("Translation method is inconsistent");
        }
        if (rightExprs.isEmpty()) {
            throw new IllegalStateException("Translation method is inconsistent");
        }
        if (leftExprs.size() == 1 && rightExprs.size() == 1 && (val = this.createOrExpression(leftExprs.get(0), rightExprs.get(0))) != null) {
            ArrayList<T> rv = new ArrayList<T>();
            rv.add(val);
            return rv;
        }
        ArrayList<T> rv = new ArrayList<T>(leftExprs.size() + rightExprs.size());
        rv.addAll(leftExprs);
        rv.addAll(rightExprs);
        return rv;
    }

    private T createLeafExpression(Filter filter) {
        boolean not;
        Filter leafFilter;
        if (filter instanceof NotFilter) {
            NotFilter nf = (NotFilter)filter;
            leafFilter = nf.getFilter();
            not = true;
        } else {
            leafFilter = filter;
            not = false;
        }
        T expr = this.createLeafExpression(leafFilter, not);
        return expr;
    }

    private T createLeafExpression(Filter filter, boolean not) {
        if (filter instanceof ContainsFilter) {
            return this.createContainsExpression((ContainsFilter)filter, not);
        }
        if (filter instanceof EndsWithFilter) {
            return this.createEndsWithExpression((EndsWithFilter)filter, not);
        }
        if (filter instanceof EqualsFilter) {
            return this.createEqualsExpression((EqualsFilter)filter, not);
        }
        if (filter instanceof EqualsIgnoreCaseFilter) {
            return this.createEqualsIgnoreCaseExpression((EqualsIgnoreCaseFilter)filter, not);
        }
        if (filter instanceof GreaterThanFilter) {
            return this.createGreaterThanExpression((GreaterThanFilter)filter, not);
        }
        if (filter instanceof GreaterThanOrEqualFilter) {
            return this.createGreaterThanOrEqualExpression((GreaterThanOrEqualFilter)filter, not);
        }
        if (filter instanceof LessThanFilter) {
            return this.createLessThanExpression((LessThanFilter)filter, not);
        }
        if (filter instanceof LessThanOrEqualFilter) {
            return this.createLessThanOrEqualExpression((LessThanOrEqualFilter)filter, not);
        }
        if (filter instanceof StartsWithFilter) {
            return this.createStartsWithExpression((StartsWithFilter)filter, not);
        }
        if (filter instanceof ContainsAllValuesFilter) {
            return this.createContainsAllValuesExpression((ContainsAllValuesFilter)filter, not);
        }
        return null;
    }

    protected T createAndExpression(T leftExpression, T rightExpression) {
        return null;
    }

    protected T createOrExpression(T leftExpression, T rightExpression) {
        return null;
    }

    protected T createContainsExpression(ContainsFilter filter, boolean not) {
        return null;
    }

    protected T createEndsWithExpression(EndsWithFilter filter, boolean not) {
        return null;
    }

    protected T createEqualsExpression(EqualsFilter filter, boolean not) {
        return null;
    }

    protected T createEqualsIgnoreCaseExpression(EqualsIgnoreCaseFilter filter, boolean not) {
        return null;
    }

    protected T createGreaterThanExpression(GreaterThanFilter filter, boolean not) {
        return null;
    }

    protected T createGreaterThanOrEqualExpression(GreaterThanOrEqualFilter filter, boolean not) {
        return null;
    }

    protected T createLessThanExpression(LessThanFilter filter, boolean not) {
        return null;
    }

    protected T createLessThanOrEqualExpression(LessThanOrEqualFilter filter, boolean not) {
        return null;
    }

    protected T createStartsWithExpression(StartsWithFilter filter, boolean not) {
        return null;
    }

    protected T createContainsAllValuesExpression(ContainsAllValuesFilter filter, boolean not) {
        return null;
    }
}

