/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.core.client.Client;
import org.pac4j.oidc.client.AzureAd2Client;
import org.pac4j.oidc.client.GoogleOidcClient;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.AzureAd2OidcConfiguration;
import org.pac4j.oidc.config.OidcConfiguration;

public class OidcClientBuilder
extends AbstractBuilder {
    public OidcClientBuilder(Map<String, String> properties) {
        super(properties);
    }

    public void tryCreateOidcClient(Collection<Client> clients) {
        for (int i = 0; i <= 100; ++i) {
            Object oidcClient;
            String clientAuthenticationMethod;
            String maxClockSkew;
            String jwsAlgo;
            String withState;
            String useNonce;
            String responseMode;
            String responseType;
            String discoveryUri;
            String scope;
            String id = this.getProperty("oidc.id", i);
            if (!StringUtils.isNotBlank((CharSequence)id)) continue;
            OidcConfiguration configuration = new OidcConfiguration();
            configuration.setClientId(id);
            String secret = this.getProperty("oidc.secret", i);
            if (StringUtils.isNotBlank((CharSequence)secret)) {
                configuration.setSecret(secret);
            }
            if (StringUtils.isNotBlank((CharSequence)(scope = this.getProperty("oidc.scope", i)))) {
                configuration.setScope(scope);
            }
            if (StringUtils.isNotBlank((CharSequence)(discoveryUri = this.getProperty("oidc.discoveryUri", i)))) {
                configuration.setDiscoveryURI(discoveryUri);
            }
            if (StringUtils.isNotBlank((CharSequence)(responseType = this.getProperty("oidc.responseType", i)))) {
                configuration.setResponseType(responseType);
            }
            if (StringUtils.isNotBlank((CharSequence)(responseMode = this.getProperty("oidc.responseMode", i)))) {
                configuration.setResponseMode(responseMode);
            }
            if (StringUtils.isNotBlank((CharSequence)(useNonce = this.getProperty("oidc.useNonce", i)))) {
                configuration.setUseNonce(Boolean.parseBoolean(useNonce));
            }
            if (StringUtils.isNotBlank((CharSequence)(withState = this.getProperty("oidc.withState", i)))) {
                configuration.setWithState(Boolean.parseBoolean(withState));
            }
            if (StringUtils.isNotBlank((CharSequence)(jwsAlgo = this.getProperty("oidc.preferredJwsAlgorithm", i)))) {
                configuration.setPreferredJwsAlgorithm(JWSAlgorithm.parse((String)jwsAlgo));
            }
            if (StringUtils.isNotBlank((CharSequence)(maxClockSkew = this.getProperty("oidc.maxClockSkew", i)))) {
                configuration.setMaxClockSkew(Integer.parseInt(maxClockSkew));
            }
            if (StringUtils.isNotBlank((CharSequence)(clientAuthenticationMethod = this.getProperty("oidc.clientAuthenticationMethod", i)))) {
                configuration.setClientAuthenticationMethod(ClientAuthenticationMethod.parse((String)clientAuthenticationMethod));
            }
            for (int j = 1; j <= 5; ++j) {
                if (!this.containsProperty("oidc.customParamKey" + j, i)) continue;
                configuration.addCustomParam(this.getProperty("oidc.customParamKey" + j, i), this.getProperty("oidc.customParamValue" + j, i));
            }
            String type = this.getProperty("oidc.type", i);
            if ("azure".equalsIgnoreCase(type)) {
                AzureAd2OidcConfiguration azureAdConfiguration = new AzureAd2OidcConfiguration(configuration);
                String tenant = this.getProperty("oidc.azure.tenant", i);
                if (StringUtils.isNotBlank((CharSequence)tenant)) {
                    azureAdConfiguration.setTenant(tenant);
                }
                oidcClient = new AzureAd2Client(azureAdConfiguration);
            } else {
                oidcClient = "google".equalsIgnoreCase(type) ? new GoogleOidcClient(configuration) : new OidcClient(configuration);
            }
            oidcClient.setName(this.concat(oidcClient.getName(), i));
            clients.add((Client)oidcClient);
        }
    }
}

