/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.context.Lifecycle;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.IntegrationConsumer;
import org.springframework.integration.router.MessageRouter;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EventDrivenConsumer
extends AbstractEndpoint
implements IntegrationConsumer {
    private final SubscribableChannel inputChannel;
    private final MessageHandler handler;

    public EventDrivenConsumer(SubscribableChannel inputChannel, MessageHandler handler) {
        Assert.notNull((Object)inputChannel, (String)"inputChannel must not be null");
        Assert.notNull((Object)handler, (String)"handler must not be null");
        this.inputChannel = inputChannel;
        this.handler = handler;
        if (this.handler instanceof MessageProducer) {
            this.setPhase(-2147482648);
        } else {
            this.setPhase(Integer.MIN_VALUE);
        }
    }

    @Override
    public MessageChannel getInputChannel() {
        return this.inputChannel;
    }

    @Override
    public MessageChannel getOutputChannel() {
        MessageHandler messageHandler = this.handler;
        if (messageHandler instanceof MessageProducer) {
            MessageProducer messageProducer = (MessageProducer)messageHandler;
            return messageProducer.getOutputChannel();
        }
        messageHandler = this.handler;
        if (messageHandler instanceof MessageRouter) {
            MessageRouter messageRouter = (MessageRouter)messageHandler;
            return messageRouter.getDefaultOutputChannel();
        }
        return null;
    }

    @Override
    public MessageHandler getHandler() {
        return this.handler;
    }

    @Override
    protected void doStart() {
        this.logComponentSubscriptionEvent(true);
        this.inputChannel.subscribe(this.handler);
        MessageHandler messageHandler = this.handler;
        if (messageHandler instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)messageHandler;
            lifecycle.start();
        }
    }

    @Override
    protected void doStop() {
        this.logComponentSubscriptionEvent(false);
        this.inputChannel.unsubscribe(this.handler);
        MessageHandler messageHandler = this.handler;
        if (messageHandler instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)messageHandler;
            lifecycle.stop();
        }
    }

    private void logComponentSubscriptionEvent(boolean add) {
        MessageHandler messageHandler = this.handler;
        if (messageHandler instanceof NamedComponent) {
            NamedComponent namedHandler = (NamedComponent)messageHandler;
            messageHandler = this.inputChannel;
            if (messageHandler instanceof NamedComponent) {
                NamedComponent namedChannel = (NamedComponent)messageHandler;
                String componentType = namedHandler.getComponentType();
                componentType = StringUtils.hasText((String)componentType) ? componentType : "";
                Object componentName = this.getComponentName();
                componentName = StringUtils.hasText((String)componentName) && ((String)componentName).contains("#") ? "" : ":" + (String)componentName;
                StringBuilder buffer = new StringBuilder();
                buffer.append("{").append(componentType).append((String)componentName).append("} as a subscriber to the '").append(namedChannel.getComponentName()).append("' channel");
                if (add) {
                    buffer.insert(0, "Adding ");
                } else {
                    buffer.insert(0, "Removing ");
                }
                this.logger.info((CharSequence)buffer.toString());
            }
        }
    }
}

