/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.saml2;

import java.time.Period;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jBaseClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.pac4j.authentication.attributes.GroovyAttributeConverter;
import org.apereo.cas.support.pac4j.authentication.clients.ConfigurableDelegatedClient;
import org.apereo.cas.support.pac4j.authentication.clients.ConfigurableDelegatedClientBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.DefaultSAML2MetadataSigner;
import org.pac4j.saml.metadata.SAML2MetadataSigner;
import org.pac4j.saml.metadata.SAML2ServiceProviderRequestedAttribute;
import org.pac4j.saml.store.EmptyStoreFactory;
import org.pac4j.saml.store.HttpSessionStoreFactory;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class DelegatedClientSaml2Builder
implements ConfigurableDelegatedClientBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientSaml2Builder.class);
    private final CasSSLContext casSslContext;
    private final ObjectProvider<SAMLMessageStoreFactory> samlMessageStoreFactory;

    public List<ConfigurableDelegatedClient> build(CasConfigurationProperties casProperties) {
        return this.buildSaml2IdentityProviders(casProperties);
    }

    protected List<ConfigurableDelegatedClient> buildSaml2IdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Optional scriptFactory = ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory();
        return pac4jProperties.getSaml().stream().filter(saml -> saml.isEnabled() && StringUtils.isNotBlank((CharSequence)saml.getMetadata().getIdentityProviderMetadataPath()) && StringUtils.isNotBlank((CharSequence)saml.getServiceProviderEntityId())).map(saml -> {
            List mappedAttributes;
            String keystorePath = SpringExpressionLanguageValueResolver.getInstance().resolve((String)StringUtils.defaultIfBlank((CharSequence)saml.getKeystorePath(), (CharSequence)Beans.getTempFilePath((String)"samlSpKeystore", (String)".jks")));
            String identityProviderMetadataPath = SpringExpressionLanguageValueResolver.getInstance().resolve(saml.getMetadata().getIdentityProviderMetadataPath());
            LOGGER.debug("Creating SAML2 identity provider [{}] with identity provider metadata [{}]", (Object)saml.getClientName(), (Object)identityProviderMetadataPath);
            SAML2Configuration configuration = new SAML2Configuration(keystorePath, saml.getKeystorePassword(), saml.getPrivateKeyPassword(), identityProviderMetadataPath);
            configuration.setForceKeystoreGeneration(saml.isForceKeystoreGeneration());
            FunctionUtils.doIf((saml.getCertificateExpirationDays() > 0 ? 1 : 0) != 0, __ -> configuration.setCertificateExpirationPeriod(Period.ofDays(saml.getCertificateExpirationDays()))).accept(saml);
            FunctionUtils.doIfNotNull((Object)saml.getResponseBindingType(), arg_0 -> ((SAML2Configuration)configuration).setResponseBindingType(arg_0));
            FunctionUtils.doIfNotNull((Object)saml.getCertificateSignatureAlg(), arg_0 -> ((SAML2Configuration)configuration).setCertificateSignatureAlg(arg_0));
            configuration.setPartialLogoutTreatedAsSuccess(saml.isPartialLogoutAsSuccess());
            configuration.setResponseDestinationAttributeMandatory(saml.isResponseDestinationMandatory());
            configuration.setSupportedProtocols(saml.getSupportedProtocols());
            FunctionUtils.doIfNotBlank((CharSequence)saml.getRequestInitiatorUrl(), __ -> configuration.setRequestInitiatorUrl(saml.getRequestInitiatorUrl()));
            FunctionUtils.doIfNotBlank((CharSequence)saml.getSingleLogoutServiceUrl(), __ -> configuration.setSingleSignOutServiceUrl(saml.getSingleLogoutServiceUrl()));
            FunctionUtils.doIfNotBlank((CharSequence)saml.getLogoutResponseBindingType(), __ -> configuration.setSpLogoutResponseBindingType(saml.getLogoutResponseBindingType()));
            configuration.setCertificateNameToAppend((String)StringUtils.defaultIfBlank((CharSequence)saml.getCertificateNameToAppend(), (CharSequence)saml.getClientName()));
            configuration.setMaximumAuthenticationLifetime(Beans.newDuration((String)saml.getMaximumAuthenticationLifetime()).toSeconds());
            String serviceProviderEntityId = SpringExpressionLanguageValueResolver.getInstance().resolve(saml.getServiceProviderEntityId());
            configuration.setServiceProviderEntityId(serviceProviderEntityId);
            String samlSpMetadata = (String)StringUtils.defaultIfBlank((CharSequence)saml.getMetadata().getServiceProvider().getFileSystem().getLocation(), (CharSequence)Beans.getTempFilePath((String)"samlSpMetadata", (String)".xml"));
            FunctionUtils.doIfNotNull((Object)samlSpMetadata, location -> {
                AbstractResource resource = ResourceUtils.getRawResourceFrom((String)location);
                LOGGER.debug("Service provider metadata is located at [{}] with entity id [{}]", (Object)resource, (Object)serviceProviderEntityId);
                configuration.setServiceProviderMetadataResource((Resource)resource);
            });
            configuration.setAuthnRequestBindingType(saml.getDestinationBinding());
            configuration.setSpLogoutRequestBindingType(saml.getLogoutRequestBinding());
            configuration.setForceAuth(saml.isForceAuth());
            configuration.setPassive(saml.isPassive());
            configuration.setSignMetadata(saml.isSignServiceProviderMetadata());
            configuration.setMetadataSigner((SAML2MetadataSigner)new DefaultSAML2MetadataSigner(configuration));
            configuration.setAuthnRequestSigned(saml.isSignAuthnRequest());
            configuration.setSpLogoutRequestSigned(saml.isSignServiceProviderLogoutRequest());
            configuration.setAcceptedSkew(Beans.newDuration((String)saml.getAcceptedSkew()).toSeconds());
            configuration.setSslSocketFactory(this.casSslContext.getSslContext().getSocketFactory());
            configuration.setHostnameVerifier(this.casSslContext.getHostnameVerifier());
            FunctionUtils.doIfNotBlank((CharSequence)saml.getPrincipalIdAttribute(), __ -> configuration.setAttributeAsId(saml.getPrincipalIdAttribute()));
            FunctionUtils.doIfNotBlank((CharSequence)saml.getNameIdAttribute(), __ -> configuration.setNameIdAttribute(saml.getNameIdAttribute()));
            configuration.setWantsAssertionsSigned(saml.isWantsAssertionsSigned());
            configuration.setWantsResponsesSigned(saml.isWantsResponsesSigned());
            configuration.setAllSignatureValidationDisabled(saml.isAllSignatureValidationDisabled());
            configuration.setUseNameQualifier(saml.isUseNameQualifier());
            configuration.setAttributeConsumingServiceIndex(saml.getAttributeConsumingServiceIndex());
            Optional.ofNullable((SAMLMessageStoreFactory)this.samlMessageStoreFactory.getIfAvailable()).ifPresentOrElse(arg_0 -> ((SAML2Configuration)configuration).setSamlMessageStoreFactory(arg_0), () -> {
                FunctionUtils.doIf((boolean)"EMPTY".equalsIgnoreCase(saml.getMessageStoreFactory()), ig -> configuration.setSamlMessageStoreFactory((SAMLMessageStoreFactory)new EmptyStoreFactory())).accept(saml);
                FunctionUtils.doIf((boolean)"SESSION".equalsIgnoreCase(saml.getMessageStoreFactory()), ig -> configuration.setSamlMessageStoreFactory((SAMLMessageStoreFactory)new HttpSessionStoreFactory())).accept(saml);
                if (saml.getMessageStoreFactory().contains(".")) {
                    FunctionUtils.doAndHandle(__ -> {
                        Class clazz = ClassUtils.getClass((ClassLoader)this.getClass().getClassLoader(), (String)saml.getMessageStoreFactory());
                        SAMLMessageStoreFactory factory = (SAMLMessageStoreFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        configuration.setSamlMessageStoreFactory(factory);
                    });
                }
            });
            FunctionUtils.doIf((saml.getAssertionConsumerServiceIndex() >= 0 ? 1 : 0) != 0, __ -> configuration.setAssertionConsumerServiceIndex(saml.getAssertionConsumerServiceIndex())).accept(saml);
            if (!saml.getAuthnContextClassRef().isEmpty()) {
                configuration.setComparisonType(saml.getAuthnContextComparisonType().toUpperCase(Locale.ENGLISH));
                configuration.setAuthnContextClassRefs(saml.getAuthnContextClassRef());
            }
            FunctionUtils.doIfNotBlank((CharSequence)saml.getNameIdPolicyFormat(), __ -> configuration.setNameIdPolicyFormat(saml.getNameIdPolicyFormat()));
            if (!saml.getRequestedAttributes().isEmpty()) {
                saml.getRequestedAttributes().stream().map(attribute -> new SAML2ServiceProviderRequestedAttribute(attribute.getName(), attribute.getFriendlyName(), attribute.getNameFormat(), attribute.isRequired())).forEach(attribute -> configuration.getRequestedServiceProviderAttributes().add(attribute));
            }
            if (!saml.getBlockedSignatureSigningAlgorithms().isEmpty()) {
                configuration.setBlackListedSignatureSigningAlgorithms((Collection)saml.getBlockedSignatureSigningAlgorithms());
            }
            if (!saml.getSignatureAlgorithms().isEmpty()) {
                configuration.setSignatureAlgorithms(saml.getSignatureAlgorithms());
            }
            if (!saml.getSignatureReferenceDigestMethods().isEmpty()) {
                configuration.setSignatureReferenceDigestMethods(saml.getSignatureReferenceDigestMethods());
            }
            FunctionUtils.doIfNotBlank((CharSequence)saml.getSignatureCanonicalizationAlgorithm(), __ -> configuration.setSignatureCanonicalizationAlgorithm(saml.getSignatureCanonicalizationAlgorithm()));
            configuration.setProviderName(saml.getProviderName());
            configuration.setNameIdPolicyAllowCreate(saml.getNameIdPolicyAllowCreate().toBoolean());
            if (StringUtils.isNotBlank((CharSequence)saml.getSaml2AttributeConverter())) {
                if (scriptFactory.isPresent() && ((ExecutableCompiledScriptFactory)scriptFactory.get()).isExternalScript(saml.getSaml2AttributeConverter())) {
                    FunctionUtils.doAndHandle(__ -> {
                        AbstractResource resource = ResourceUtils.getResourceFrom((String)saml.getSaml2AttributeConverter());
                        ExecutableCompiledScript script = ((ExecutableCompiledScriptFactory)scriptFactory.get()).fromResource((Resource)resource);
                        configuration.setSamlAttributeConverter((AttributeConverter)new GroovyAttributeConverter(script));
                    });
                } else {
                    FunctionUtils.doAndHandle(__ -> {
                        Class clazz = ClassUtils.getClass((ClassLoader)this.getClass().getClassLoader(), (String)saml.getSaml2AttributeConverter());
                        AttributeConverter converter = (AttributeConverter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        configuration.setSamlAttributeConverter(converter);
                    });
                }
            }
            if (!(mappedAttributes = saml.getMappedAttributes()).isEmpty()) {
                configuration.setMappedAttributes(CollectionUtils.convertDirectedListToMap((Collection)mappedAttributes));
            }
            SAML2Client client = new SAML2Client(configuration);
            LOGGER.debug("Created SAML2 delegated client [{}]", (Object)client);
            return new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)saml);
        }).collect(Collectors.toList());
    }

    public BaseClient configure(BaseClient client, Pac4jBaseClientProperties clientProperties, CasConfigurationProperties properties) {
        SAML2Client saml2Client;
        if (client instanceof SAML2Client && (saml2Client = (SAML2Client)client).isInitialized()) {
            saml2Client.getIdentityProviderMetadataResolver().resolve(true);
        }
        return client;
    }

    @Generated
    public DelegatedClientSaml2Builder(CasSSLContext casSslContext, ObjectProvider<SAMLMessageStoreFactory> samlMessageStoreFactory) {
        this.casSslContext = casSslContext;
        this.samlMessageStoreFactory = samlMessageStoreFactory;
    }
}

