/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.codegen;

import com.googlecode.cqengine.codegen.MemberFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class MemberFilters {
    public static final MemberFilter ALL_MEMBERS = member -> true;
    public static final MemberFilter FIELDS_ONLY = member -> member instanceof Field;
    public static final MemberFilter METHODS_ONLY = member -> member instanceof Method;
    public static final MemberFilter GETTER_METHODS_ONLY = member -> {
        if (member instanceof Method) {
            for (GetterPrefix prefix : GetterPrefix.values()) {
                if (!MemberFilters.hasGetterPrefix(member.getName(), prefix.name())) continue;
                return true;
            }
        }
        return false;
    };

    static boolean hasGetterPrefix(String memberName, String prefix) {
        int prefixLength = prefix.length();
        return memberName.length() > prefixLength && memberName.startsWith(prefix) && Character.isUpperCase(memberName.charAt(prefixLength));
    }

    MemberFilters() {
    }

    static enum GetterPrefix {
        get,
        is,
        has;

    }
}

