/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.simple;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import com.googlecode.cqengine.query.simple.StringContains;
import com.googlecode.cqengine.query.support.QueryValidation;

public class StringIsContainedIn<O, A extends CharSequence>
extends SimpleQuery<O, A> {
    private final A value;

    public StringIsContainedIn(Attribute<O, A> attribute, A value) {
        super(attribute);
        this.value = (CharSequence)QueryValidation.checkQueryValueNotNull(value);
    }

    public A getValue() {
        return this.value;
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        CharSequence attributeValue = (CharSequence)attribute.getValue(object, queryOptions);
        return StringContains.containsFragment(this.value, attributeValue);
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        for (CharSequence attributeValue : attribute.getValues(object, queryOptions)) {
            if (!StringContains.containsFragment(this.value, attributeValue)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringIsContainedIn)) {
            return false;
        }
        StringIsContainedIn that = (StringIsContainedIn)o;
        if (!this.attribute.equals(that.attribute)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    @Override
    protected int calcHashCode() {
        int result = this.attribute.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "isContainedIn(" + StringIsContainedIn.asLiteral(super.getAttributeName()) + ", " + StringIsContainedIn.asLiteral(this.value) + ")";
    }
}

