/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.operations.UpdateDeltaApiOp;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.GetImpl;
import org.identityconnectors.framework.impl.api.local.operations.ObjectNormalizerFacade;
import org.identityconnectors.framework.impl.api.local.operations.SearchImpl;
import org.identityconnectors.framework.impl.api.local.operations.SpiOperationLoggingUtil;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.UpdateAttributeValuesOp;
import org.identityconnectors.framework.spi.operations.UpdateDeltaOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

public class UpdateDeltaImpl
extends ConnectorAPIOperationRunner
implements UpdateDeltaApiOp {
    private static final Log OP_LOG = Log.getLog(UpdateDeltaOp.class);
    private static final Set<String> OPERATIONAL_ATTRIBUTE_NAMES = new HashSet<String>();
    private static final String OPERATIONAL_ATTRIBUTE_ERR = "Operational attribute '%s' can not be added or removed.";

    public UpdateDeltaImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    public Set<AttributeDelta> updateDelta(ObjectClass objclass, Uid uid, Set<AttributeDelta> modifications, OperationOptions options) {
        Uid ret;
        UpdateOp op;
        Assertions.nullCheck((Object)uid, (String)"uid");
        Assertions.nullCheck((Object)objclass, (String)"objectClass");
        if (ObjectClass.ALL.equals((Object)objclass)) {
            throw new UnsupportedOperationException("Operation is not allowed on __ALL__ object class");
        }
        Assertions.nullCheck(modifications, (String)"modifications");
        for (AttributeDelta attrDelta : modifications) {
            if (!attrDelta.is(Uid.NAME)) continue;
            throw new InvalidAttributeValueException("Parameter 'modifications' contains a uid.");
        }
        for (AttributeDelta attrDelta : modifications) {
            Assertions.nullCheck((Object)attrDelta, (String)"attrDelta from modifications");
            if (attrDelta.getValuesToAdd() == null && attrDelta.getValuesToRemove() == null && attrDelta.getValuesToReplace() == null) {
                throw new IllegalArgumentException("Lists of added, removed and replaced values can not be 'null'.");
            }
            if (attrDelta.getValuesToReplace() != null) continue;
            String name = attrDelta.getName();
            if (OperationalAttributes.PASSWORD_NAME.equals(name)) {
                if (attrDelta.getValuesToAdd() == null) {
                    throw new IllegalArgumentException("Missing values to add in non-replace password operation");
                }
                if (attrDelta.getValuesToRemove() != null) continue;
                throw new IllegalArgumentException("Missing values to remove in non-replace password operation");
            }
            if (!OPERATIONAL_ATTRIBUTE_NAMES.contains(name)) continue;
            String msg = String.format(OPERATIONAL_ATTRIBUTE_ERR, name);
            throw new IllegalArgumentException(msg);
        }
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        ObjectNormalizerFacade normalizer = this.getNormalizer(objclass);
        uid = (Uid)normalizer.normalizeAttribute((Attribute)uid);
        modifications = this.normalizeSetAttributesDelta(normalizer, modifications);
        Connector conector = this.getConnector();
        if (conector instanceof UpdateDeltaOp) {
            Set attrsDelta;
            UpdateDeltaOp deltaOp = (UpdateDeltaOp)conector;
            this.logOpEntry("updateDelta", objclass, uid, modifications, options);
            try {
                attrsDelta = deltaOp.updateDelta(objclass, uid, modifications, options);
            }
            catch (RuntimeException e) {
                this.logOpException("updateDelta", e);
                throw e;
            }
            this.logOpExit("updateDelta", attrsDelta);
            return this.normalizeSetAttributesDelta(normalizer, attrsDelta);
        }
        if (conector instanceof UpdateAttributeValuesOp) {
            op = (UpdateOp)conector;
            UpdateAttributeValuesOp valueOp = (UpdateAttributeValuesOp)conector;
            HashSet<Attribute> valuesToRemove = new HashSet<Attribute>();
            HashSet<Attribute> valuesToAdd = new HashSet<Attribute>();
            HashSet<Attribute> valuesToReplace = new HashSet<Attribute>();
            for (AttributeDelta attrDelta : modifications) {
                if (attrDelta.getValuesToReplace() != null) {
                    valuesToReplace.add(AttributeBuilder.build((String)attrDelta.getName(), (Collection)attrDelta.getValuesToReplace()));
                    continue;
                }
                if (attrDelta.getValuesToAdd() != null) {
                    valuesToAdd.add(AttributeBuilder.build((String)attrDelta.getName(), (Collection)attrDelta.getValuesToAdd()));
                }
                if (attrDelta.getValuesToRemove() == null) continue;
                valuesToRemove.add(AttributeBuilder.build((String)attrDelta.getName(), (Collection)attrDelta.getValuesToRemove()));
            }
            Uid newUid = uid;
            if (!valuesToReplace.isEmpty()) {
                try {
                    newUid = op.update(objclass, uid, valuesToReplace, options);
                }
                catch (RuntimeException e) {
                    this.logOpException("update", e);
                    throw e;
                }
                if (newUid == null) {
                    OP_LOG.warn("Return value from update is 'null'.", new Object[0]);
                }
            }
            if (!valuesToAdd.isEmpty() && (newUid = this.executeUpdateAttributeValues(valueOp, "addAttributeValues", objclass, newUid, valuesToAdd, options, true)) == null) {
                OP_LOG.warn("Return value from addAttributeValues is 'null'.", new Object[0]);
            }
            if (!valuesToRemove.isEmpty() && (newUid = this.executeUpdateAttributeValues(valueOp, "removeAttributeValues", objclass, newUid, valuesToRemove, options, false)) == null) {
                OP_LOG.warn("Return value from removeAttributeValues is 'null'.", new Object[0]);
            }
            HashSet<AttributeDelta> sideEffectAttributesDelta = new HashSet<AttributeDelta>();
            if (newUid != null && !uid.getUidValue().equals(newUid.getUidValue())) {
                sideEffectAttributesDelta.add(AttributeDeltaBuilder.build((String)Uid.NAME, (Object[])new Object[]{newUid.getUidValue()}));
            }
            return sideEffectAttributesDelta;
        }
        op = (UpdateOp)conector;
        if (!(this.getConnector() instanceof SearchOp)) {
            throw new UnsupportedOperationException("Connector must support: " + String.valueOf(SearchOp.class));
        }
        OperationOptionsBuilder builder = new OperationOptionsBuilder(options);
        HashSet<String> attrNames = new HashSet<String>();
        for (AttributeDelta attributeDelta : modifications) {
            attrNames.add(attributeDelta.getName());
        }
        builder.setAttributesToGet(attrNames);
        options = builder.build();
        ConnectorObject o = this.getConnectorObject(objclass, uid, options);
        if (o == null) {
            throw new UnknownUidException(uid, objclass);
        }
        Set attrsFromSearch = o.getAttributes();
        HashSet<Attribute> attributesForUpdate = new HashSet<Attribute>();
        Map attrsFromSearchMap = AttributeUtil.toMap((Collection)attrsFromSearch);
        for (AttributeDelta attrFromModification : modifications) {
            Attribute attrForUpdate;
            String name = attrFromModification.getName();
            if (attrFromModification.getValuesToReplace() != null) {
                attributesForUpdate.add(AttributeBuilder.build((String)name, (Collection)attrFromModification.getValuesToReplace()));
                continue;
            }
            Attribute attrFromSearch = (Attribute)attrsFromSearchMap.get(name);
            if (attrFromSearch == null && attrFromModification.getValuesToAdd() != null) {
                attrForUpdate = AttributeBuilder.build((String)name, (Collection)attrFromModification.getValuesToAdd());
            } else {
                if (attrFromSearch == null) continue;
                List values = CollectionUtil.newList((Collection)attrFromSearch.getValue());
                if (attrFromModification.getValuesToAdd() != null) {
                    values.addAll(attrFromModification.getValuesToAdd());
                }
                if (attrFromModification.getValuesToRemove() != null) {
                    attrFromModification.getValuesToRemove().forEach(val -> values.remove(val));
                }
                attrForUpdate = AttributeBuilder.build((String)name, (Collection)values);
            }
            attributesForUpdate.add(attrForUpdate);
        }
        this.logOpEntry("update", objclass, uid, attributesForUpdate, options);
        try {
            ret = op.update(objclass, uid, attributesForUpdate, options);
        }
        catch (RuntimeException e) {
            this.logOpException("update", e);
            throw e;
        }
        this.logOpExit("update", ret);
        if (ret == null) {
            return null;
        }
        HashSet<AttributeDelta> sideEffectAttributesDelta = new HashSet<AttributeDelta>();
        if (!uid.attributeEquals((Object)ret)) {
            sideEffectAttributesDelta.add(AttributeDeltaBuilder.build((String)Uid.NAME, (Collection)ret.getValue()));
        }
        return sideEffectAttributesDelta;
    }

    private Uid executeUpdateAttributeValues(UpdateAttributeValuesOp valueOp, String method, ObjectClass objclass, Uid uid, Set<Attribute> valuesToUpdate, OperationOptions options, boolean add) {
        this.logOpEntry(method, objclass, uid, valuesToUpdate, options);
        Uid ret = null;
        try {
            ret = !valuesToUpdate.isEmpty() && !add ? valueOp.removeAttributeValues(objclass, uid, valuesToUpdate, options) : valueOp.addAttributeValues(objclass, uid, valuesToUpdate, options);
        }
        catch (RuntimeException e) {
            this.logOpException(method, e);
            throw e;
        }
        this.logOpExit(method, ret);
        return ret;
    }

    private Set<AttributeDelta> normalizeSetAttributesDelta(ObjectNormalizerFacade normalizer, Set<AttributeDelta> attrsDelta) {
        if (attrsDelta == null) {
            return null;
        }
        HashSet<AttributeDelta> normalizeModifications = new HashSet<AttributeDelta>();
        List<Object> addValues = null;
        List<Object> removeValues = null;
        for (AttributeDelta attrDelta : attrsDelta) {
            AttributeDelta tempAttrDelta;
            if (attrDelta.getValuesToReplace() != null) {
                List<Object> replaceValues = this.normalizeListAttributesValues(normalizer, attrDelta.getName(), attrDelta.getValuesToReplace());
                tempAttrDelta = AttributeDeltaBuilder.build((String)attrDelta.getName(), replaceValues);
            } else {
                addValues = null;
                removeValues = null;
                if (attrDelta.getValuesToAdd() != null) {
                    addValues = this.normalizeListAttributesValues(normalizer, attrDelta.getName(), attrDelta.getValuesToAdd());
                }
                if (attrDelta.getValuesToRemove() != null) {
                    removeValues = this.normalizeListAttributesValues(normalizer, attrDelta.getName(), attrDelta.getValuesToRemove());
                }
                tempAttrDelta = AttributeDeltaBuilder.build((String)attrDelta.getName(), addValues, removeValues);
            }
            normalizeModifications.add(tempAttrDelta);
        }
        return Collections.unmodifiableSet(normalizeModifications);
    }

    private List<Object> normalizeListAttributesValues(ObjectNormalizerFacade normalizer, String name, List<Object> values) {
        return values.stream().map(value -> normalizer.normalizeAttribute(AttributeBuilder.build((String)name, (Object[])new Object[]{value})).getValue().get(0)).collect(Collectors.toList());
    }

    private ConnectorObject getConnectorObject(ObjectClass oclass, Uid uid, OperationOptions options) {
        GetImpl get = new GetImpl(new SearchImpl(this.getOperationalContext(), this.getConnector()));
        return get.getObject(oclass, uid, options);
    }

    private void logOpEntry(String opName, Object ... params) {
        SpiOperationLoggingUtil.logOpEntry(OP_LOG, this.getOperationalContext(), UpdateDeltaOp.class, opName, params);
    }

    private void logOpExit(String opName, Object returnValue) {
        SpiOperationLoggingUtil.logOpExit(OP_LOG, this.getOperationalContext(), UpdateOp.class, opName, returnValue);
    }

    private void logOpException(String opName, RuntimeException e) {
        SpiOperationLoggingUtil.logOpException(OP_LOG, this.getOperationalContext(), UpdateOp.class, opName, e);
    }

    static {
        OPERATIONAL_ATTRIBUTE_NAMES.addAll(OperationalAttributes.getOperationalAttributeNames());
        OPERATIONAL_ATTRIBUTE_NAMES.add(Name.NAME);
    }
}

